package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class IngressControllerHTTPHeadersFluentImpl<A extends io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersFluent<A> {

    private java.lang.String forwardedHeaderPolicy;
    private java.util.List<java.lang.String> headerNameCaseAdjustments = new java.util.ArrayList<java.lang.String>();
    private io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicyBuilder uniqueId;

    public IngressControllerHTTPHeadersFluentImpl() {
    }

    public IngressControllerHTTPHeadersFluentImpl(io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeaders instance) {
        this.withForwardedHeaderPolicy(instance.getForwardedHeaderPolicy()); 
        this.withHeaderNameCaseAdjustments(instance.getHeaderNameCaseAdjustments()); 
        this.withUniqueId(instance.getUniqueId()); 
    }

    public java.lang.String getForwardedHeaderPolicy() {
        return this.forwardedHeaderPolicy;
    }

    public A withForwardedHeaderPolicy(java.lang.String forwardedHeaderPolicy) {
        this.forwardedHeaderPolicy=forwardedHeaderPolicy; return (A) this;
    }

    public java.lang.Boolean hasForwardedHeaderPolicy() {
        return this.forwardedHeaderPolicy != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withForwardedHeaderPolicy instead.
     */
        public A withNewForwardedHeaderPolicy(java.lang.String arg0) {
        return (A)withForwardedHeaderPolicy(new String(arg0));
    }

    public A addToHeaderNameCaseAdjustments(int index,java.lang.String item) {
        if (this.headerNameCaseAdjustments == null) {this.headerNameCaseAdjustments = new java.util.ArrayList<java.lang.String>();}
        this.headerNameCaseAdjustments.add(index, item);
        return (A)this;
    }

    public A setToHeaderNameCaseAdjustments(int index,java.lang.String item) {
        if (this.headerNameCaseAdjustments == null) {this.headerNameCaseAdjustments = new java.util.ArrayList<java.lang.String>();}
        this.headerNameCaseAdjustments.set(index, item); return (A)this;
    }

    public A addToHeaderNameCaseAdjustments(java.lang.String... items) {
        if (this.headerNameCaseAdjustments == null) {this.headerNameCaseAdjustments = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.headerNameCaseAdjustments.add(item);} return (A)this;
    }

    public A addAllToHeaderNameCaseAdjustments(java.util.Collection<java.lang.String> items) {
        if (this.headerNameCaseAdjustments == null) {this.headerNameCaseAdjustments = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.headerNameCaseAdjustments.add(item);} return (A)this;
    }

    public A removeFromHeaderNameCaseAdjustments(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.headerNameCaseAdjustments!= null){ this.headerNameCaseAdjustments.remove(item);}} return (A)this;
    }

    public A removeAllFromHeaderNameCaseAdjustments(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.headerNameCaseAdjustments!= null){ this.headerNameCaseAdjustments.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getHeaderNameCaseAdjustments() {
        return this.headerNameCaseAdjustments;
    }

    public java.lang.String getHeaderNameCaseAdjustment(int index) {
        return this.headerNameCaseAdjustments.get(index);
    }

    public java.lang.String getFirstHeaderNameCaseAdjustment() {
        return this.headerNameCaseAdjustments.get(0);
    }

    public java.lang.String getLastHeaderNameCaseAdjustment() {
        return this.headerNameCaseAdjustments.get(headerNameCaseAdjustments.size() - 1);
    }

    public java.lang.String getMatchingHeaderNameCaseAdjustment(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: headerNameCaseAdjustments) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingHeaderNameCaseAdjustment(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: headerNameCaseAdjustments) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withHeaderNameCaseAdjustments(java.util.List<java.lang.String> headerNameCaseAdjustments) {
        if (this.headerNameCaseAdjustments != null) { _visitables.get("headerNameCaseAdjustments").removeAll(this.headerNameCaseAdjustments);}
        if (headerNameCaseAdjustments != null) {this.headerNameCaseAdjustments = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : headerNameCaseAdjustments){this.addToHeaderNameCaseAdjustments(item);}} else { this.headerNameCaseAdjustments = null;} return (A) this;
    }

    public A withHeaderNameCaseAdjustments(java.lang.String... headerNameCaseAdjustments) {
        if (this.headerNameCaseAdjustments != null) {this.headerNameCaseAdjustments.clear();}
        if (headerNameCaseAdjustments != null) {for (java.lang.String item :headerNameCaseAdjustments){ this.addToHeaderNameCaseAdjustments(item);}} return (A) this;
    }

    public java.lang.Boolean hasHeaderNameCaseAdjustments() {
        return headerNameCaseAdjustments != null && !headerNameCaseAdjustments.isEmpty();
    }

    public A addNewHeaderNameCaseAdjustment(java.lang.String arg0) {
        return (A)addToHeaderNameCaseAdjustments(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildUniqueId instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicy getUniqueId() {
        return this.uniqueId!=null?this.uniqueId.build():null;
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicy buildUniqueId() {
        return this.uniqueId!=null?this.uniqueId.build():null;
    }

    public A withUniqueId(io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicy uniqueId) {
        _visitables.get("uniqueId").remove(this.uniqueId);
        if (uniqueId!=null){ this.uniqueId= new io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicyBuilder(uniqueId); _visitables.get("uniqueId").add(this.uniqueId);} return (A) this;
    }

    public java.lang.Boolean hasUniqueId() {
        return this.uniqueId != null;
    }

    public A withNewUniqueId(java.lang.String format,java.lang.String name) {
        return (A)withUniqueId(new IngressControllerHTTPUniqueIdHeaderPolicy(format, name));
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersFluent.UniqueIdNested<A> withNewUniqueId() {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersFluentImpl.UniqueIdNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersFluent.UniqueIdNested<A> withNewUniqueIdLike(io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicy item) {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersFluentImpl.UniqueIdNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersFluent.UniqueIdNested<A> editUniqueId() {
        return withNewUniqueIdLike(getUniqueId());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersFluent.UniqueIdNested<A> editOrNewUniqueId() {
        return withNewUniqueIdLike(getUniqueId() != null ? getUniqueId(): new io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicyBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersFluent.UniqueIdNested<A> editOrNewUniqueIdLike(io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicy item) {
        return withNewUniqueIdLike(getUniqueId() != null ? getUniqueId(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IngressControllerHTTPHeadersFluentImpl that = (IngressControllerHTTPHeadersFluentImpl) o;
        if (forwardedHeaderPolicy != null ? !forwardedHeaderPolicy.equals(that.forwardedHeaderPolicy) :that.forwardedHeaderPolicy != null) return false;
        if (headerNameCaseAdjustments != null ? !headerNameCaseAdjustments.equals(that.headerNameCaseAdjustments) :that.headerNameCaseAdjustments != null) return false;
        if (uniqueId != null ? !uniqueId.equals(that.uniqueId) :that.uniqueId != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(forwardedHeaderPolicy,  headerNameCaseAdjustments,  uniqueId,  super.hashCode());
    }

    public class UniqueIdNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicyFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersFluent.UniqueIdNested<N>> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersFluent.UniqueIdNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicyBuilder builder;

            UniqueIdNestedImpl(io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicy item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this, item);
                        
            }

            UniqueIdNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this);
                        
            }

            public N and() {
                return (N) IngressControllerHTTPHeadersFluentImpl.this.withUniqueId(builder.build());
            }

            public N endUniqueId() {
                return and();
            }
    }


}
