package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressControllerBuilder extends io.fabric8.openshift.api.model.operator.v1.IngressControllerFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.IngressController,io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder> {

    io.fabric8.openshift.api.model.operator.v1.IngressControllerFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IngressControllerBuilder() {
        this(true);
    }

    public IngressControllerBuilder(java.lang.Boolean validationEnabled) {
        this(new IngressController(), validationEnabled);
    }

    public IngressControllerBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressControllerBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IngressController(), validationEnabled);
    }

    public IngressControllerBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.IngressController instance) {
        this(fluent, instance, true);
    }

    public IngressControllerBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.IngressController instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressControllerBuilder(io.fabric8.openshift.api.model.operator.v1.IngressController instance) {
        this(instance,true);
    }

    public IngressControllerBuilder(io.fabric8.openshift.api.model.operator.v1.IngressController instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressController build() {
        IngressController buildable = new IngressController(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressControllerBuilder that = (IngressControllerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
