package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IPAMConfigBuilder extends io.fabric8.openshift.api.model.operator.v1.IPAMConfigFluentImpl<io.fabric8.openshift.api.model.operator.v1.IPAMConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.IPAMConfig,io.fabric8.openshift.api.model.operator.v1.IPAMConfigBuilder> {

    io.fabric8.openshift.api.model.operator.v1.IPAMConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IPAMConfigBuilder() {
        this(true);
    }

    public IPAMConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new IPAMConfig(), validationEnabled);
    }

    public IPAMConfigBuilder(io.fabric8.openshift.api.model.operator.v1.IPAMConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public IPAMConfigBuilder(io.fabric8.openshift.api.model.operator.v1.IPAMConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IPAMConfig(), validationEnabled);
    }

    public IPAMConfigBuilder(io.fabric8.openshift.api.model.operator.v1.IPAMConfigFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.IPAMConfig instance) {
        this(fluent, instance, true);
    }

    public IPAMConfigBuilder(io.fabric8.openshift.api.model.operator.v1.IPAMConfigFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.IPAMConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withStaticIPAMConfig(instance.getStaticIPAMConfig()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public IPAMConfigBuilder(io.fabric8.openshift.api.model.operator.v1.IPAMConfig instance) {
        this(instance,true);
    }

    public IPAMConfigBuilder(io.fabric8.openshift.api.model.operator.v1.IPAMConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withStaticIPAMConfig(instance.getStaticIPAMConfig()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.IPAMConfig build() {
        IPAMConfig buildable = new IPAMConfig(fluent.getStaticIPAMConfig(),fluent.getType());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IPAMConfigBuilder that = (IPAMConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
