package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class HybridOverlayConfigFluentImpl<A extends io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent<A> {

    private java.util.List<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> hybridClusterNetwork =  new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>();
    private java.lang.Integer hybridOverlayVXLANPort;

    public HybridOverlayConfigFluentImpl() {
    }

    public HybridOverlayConfigFluentImpl(io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfig instance) {
        this.withHybridClusterNetwork(instance.getHybridClusterNetwork()); 
        this.withHybridOverlayVXLANPort(instance.getHybridOverlayVXLANPort()); 
    }

    public A addToHybridClusterNetwork(int index,io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item) {
        if (this.hybridClusterNetwork == null) {this.hybridClusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>();}
        io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);_visitables.get("hybridClusterNetwork").add(index >= 0 ? index : _visitables.get("hybridClusterNetwork").size(), builder);this.hybridClusterNetwork.add(index >= 0 ? index : hybridClusterNetwork.size(), builder); return (A)this;
    }

    public A setToHybridClusterNetwork(int index,io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item) {
        if (this.hybridClusterNetwork == null) {this.hybridClusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>();}
        io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= _visitables.get("hybridClusterNetwork").size()) { _visitables.get("hybridClusterNetwork").add(builder); } else { _visitables.get("hybridClusterNetwork").set(index, builder);}
        if (index < 0 || index >= hybridClusterNetwork.size()) { hybridClusterNetwork.add(builder); } else { hybridClusterNetwork.set(index, builder);}
         return (A)this;
    }

    public A addToHybridClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items) {
        if (this.hybridClusterNetwork == null) {this.hybridClusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>();}
        for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);_visitables.get("hybridClusterNetwork").add(builder);this.hybridClusterNetwork.add(builder);} return (A)this;
    }

    public A addAllToHybridClusterNetwork(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry> items) {
        if (this.hybridClusterNetwork == null) {this.hybridClusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>();}
        for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);_visitables.get("hybridClusterNetwork").add(builder);this.hybridClusterNetwork.add(builder);} return (A)this;
    }

    public A removeFromHybridClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items) {
        for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);_visitables.get("hybridClusterNetwork").remove(builder);if (this.hybridClusterNetwork != null) {this.hybridClusterNetwork.remove(builder);}} return (A)this;
    }

    public A removeAllFromHybridClusterNetwork(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry> items) {
        for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);_visitables.get("hybridClusterNetwork").remove(builder);if (this.hybridClusterNetwork != null) {this.hybridClusterNetwork.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromHybridClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> predicate) {
        if (hybridClusterNetwork == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> each = hybridClusterNetwork.iterator();
        final List visitables = _visitables.get("hybridClusterNetwork");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildHybridClusterNetwork instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry> getHybridClusterNetwork() {
        return build(hybridClusterNetwork);
    }

    public java.util.List<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry> buildHybridClusterNetwork() {
        return build(hybridClusterNetwork);
    }

    public io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry buildHybridClusterNetwork(int index) {
        return this.hybridClusterNetwork.get(index).build();
    }

    public io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry buildFirstHybridClusterNetwork() {
        return this.hybridClusterNetwork.get(0).build();
    }

    public io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry buildLastHybridClusterNetwork() {
        return this.hybridClusterNetwork.get(hybridClusterNetwork.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry buildMatchingHybridClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> predicate) {
        for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder item: hybridClusterNetwork) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingHybridClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> predicate) {
        for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder item: hybridClusterNetwork) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withHybridClusterNetwork(java.util.List<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry> hybridClusterNetwork) {
        if (this.hybridClusterNetwork != null) { _visitables.get("hybridClusterNetwork").removeAll(this.hybridClusterNetwork);}
        if (hybridClusterNetwork != null) {this.hybridClusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>(); for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item : hybridClusterNetwork){this.addToHybridClusterNetwork(item);}} else { this.hybridClusterNetwork = null;} return (A) this;
    }

    public A withHybridClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... hybridClusterNetwork) {
        if (this.hybridClusterNetwork != null) {this.hybridClusterNetwork.clear();}
        if (hybridClusterNetwork != null) {for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item :hybridClusterNetwork){ this.addToHybridClusterNetwork(item);}} return (A) this;
    }

    public java.lang.Boolean hasHybridClusterNetwork() {
        return hybridClusterNetwork != null && !hybridClusterNetwork.isEmpty();
    }

    public A addNewHybridClusterNetwork(java.lang.String cidr,java.lang.Integer hostPrefix) {
        return (A)addToHybridClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
    }

    public io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent.HybridClusterNetworkNested<A> addNewHybridClusterNetwork() {
        return new io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluentImpl.HybridClusterNetworkNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent.HybridClusterNetworkNested<A> addNewHybridClusterNetworkLike(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item) {
        return new io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluentImpl.HybridClusterNetworkNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent.HybridClusterNetworkNested<A> setNewHybridClusterNetworkLike(int index,io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item) {
        return new io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluentImpl.HybridClusterNetworkNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editHybridClusterNetwork(int index) {
        if (hybridClusterNetwork.size() <= index) throw new RuntimeException("Can't edit hybridClusterNetwork. Index exceeds size.");
        return setNewHybridClusterNetworkLike(index, buildHybridClusterNetwork(index));
    }

    public io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editFirstHybridClusterNetwork() {
        if (hybridClusterNetwork.size() == 0) throw new RuntimeException("Can't edit first hybridClusterNetwork. The list is empty.");
        return setNewHybridClusterNetworkLike(0, buildHybridClusterNetwork(0));
    }

    public io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editLastHybridClusterNetwork() {
        int index = hybridClusterNetwork.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last hybridClusterNetwork. The list is empty.");
        return setNewHybridClusterNetworkLike(index, buildHybridClusterNetwork(index));
    }

    public io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editMatchingHybridClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i=0;i<hybridClusterNetwork.size();i++) { 
        if (predicate.test(hybridClusterNetwork.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching hybridClusterNetwork. No match found.");
        return setNewHybridClusterNetworkLike(index, buildHybridClusterNetwork(index));
    }

    public java.lang.Integer getHybridOverlayVXLANPort() {
        return this.hybridOverlayVXLANPort;
    }

    public A withHybridOverlayVXLANPort(java.lang.Integer hybridOverlayVXLANPort) {
        this.hybridOverlayVXLANPort=hybridOverlayVXLANPort; return (A) this;
    }

    public java.lang.Boolean hasHybridOverlayVXLANPort() {
        return this.hybridOverlayVXLANPort != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HybridOverlayConfigFluentImpl that = (HybridOverlayConfigFluentImpl) o;
        if (hybridClusterNetwork != null ? !hybridClusterNetwork.equals(that.hybridClusterNetwork) :that.hybridClusterNetwork != null) return false;
        if (hybridOverlayVXLANPort != null ? !hybridOverlayVXLANPort.equals(that.hybridOverlayVXLANPort) :that.hybridOverlayVXLANPort != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(hybridClusterNetwork,  hybridOverlayVXLANPort,  super.hashCode());
    }

    public class HybridClusterNetworkNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryFluentImpl<io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent.HybridClusterNetworkNested<N>> implements io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent.HybridClusterNetworkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder;
        private final int index;

            HybridClusterNetworkNestedImpl(int index,io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(this, item);
                        
            }

            HybridClusterNetworkNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(this);
                        
            }

            public N and() {
                return (N) HybridOverlayConfigFluentImpl.this.setToHybridClusterNetwork(index,builder.build());
            }

            public N endHybridClusterNetwork() {
                return and();
            }
    }


}
