package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HybridOverlayConfigBuilder extends io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluentImpl<io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfig,io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigBuilder> {

    io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public HybridOverlayConfigBuilder() {
        this(true);
    }

    public HybridOverlayConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new HybridOverlayConfig(), validationEnabled);
    }

    public HybridOverlayConfigBuilder(io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public HybridOverlayConfigBuilder(io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new HybridOverlayConfig(), validationEnabled);
    }

    public HybridOverlayConfigBuilder(io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfig instance) {
        this(fluent, instance, true);
    }

    public HybridOverlayConfigBuilder(io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHybridClusterNetwork(instance.getHybridClusterNetwork()); 
        fluent.withHybridOverlayVXLANPort(instance.getHybridOverlayVXLANPort()); 
        this.validationEnabled = validationEnabled; 
    }

    public HybridOverlayConfigBuilder(io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfig instance) {
        this(instance,true);
    }

    public HybridOverlayConfigBuilder(io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withHybridClusterNetwork(instance.getHybridClusterNetwork()); 
        this.withHybridOverlayVXLANPort(instance.getHybridOverlayVXLANPort()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfig build() {
        HybridOverlayConfig buildable = new HybridOverlayConfig(fluent.getHybridClusterNetwork(),fluent.getHybridOverlayVXLANPort());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HybridOverlayConfigBuilder that = (HybridOverlayConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
