package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExportNetworkFlowsBuilder extends io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsFluentImpl<io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlows,io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsBuilder> {

    io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ExportNetworkFlowsBuilder() {
        this(true);
    }

    public ExportNetworkFlowsBuilder(java.lang.Boolean validationEnabled) {
        this(new ExportNetworkFlows(), validationEnabled);
    }

    public ExportNetworkFlowsBuilder(io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsFluent<?> fluent) {
        this(fluent, true);
    }

    public ExportNetworkFlowsBuilder(io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ExportNetworkFlows(), validationEnabled);
    }

    public ExportNetworkFlowsBuilder(io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlows instance) {
        this(fluent, instance, true);
    }

    public ExportNetworkFlowsBuilder(io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlows instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withIpfix(instance.getIpfix()); 
        fluent.withNetFlow(instance.getNetFlow()); 
        fluent.withSFlow(instance.getSFlow()); 
        this.validationEnabled = validationEnabled; 
    }

    public ExportNetworkFlowsBuilder(io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlows instance) {
        this(instance,true);
    }

    public ExportNetworkFlowsBuilder(io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlows instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withIpfix(instance.getIpfix()); 
        this.withNetFlow(instance.getNetFlow()); 
        this.withSFlow(instance.getSFlow()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlows build() {
        ExportNetworkFlows buildable = new ExportNetworkFlows(fluent.getIpfix(),fluent.getNetFlow(),fluent.getSFlow());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExportNetworkFlowsBuilder that = (ExportNetworkFlowsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
