package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EtcdBuilder extends io.fabric8.openshift.api.model.operator.v1.EtcdFluentImpl<io.fabric8.openshift.api.model.operator.v1.EtcdBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.Etcd,io.fabric8.openshift.api.model.operator.v1.EtcdBuilder> {

    io.fabric8.openshift.api.model.operator.v1.EtcdFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public EtcdBuilder() {
        this(true);
    }

    public EtcdBuilder(java.lang.Boolean validationEnabled) {
        this(new Etcd(), validationEnabled);
    }

    public EtcdBuilder(io.fabric8.openshift.api.model.operator.v1.EtcdFluent<?> fluent) {
        this(fluent, true);
    }

    public EtcdBuilder(io.fabric8.openshift.api.model.operator.v1.EtcdFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Etcd(), validationEnabled);
    }

    public EtcdBuilder(io.fabric8.openshift.api.model.operator.v1.EtcdFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.Etcd instance) {
        this(fluent, instance, true);
    }

    public EtcdBuilder(io.fabric8.openshift.api.model.operator.v1.EtcdFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.Etcd instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public EtcdBuilder(io.fabric8.openshift.api.model.operator.v1.Etcd instance) {
        this(instance,true);
    }

    public EtcdBuilder(io.fabric8.openshift.api.model.operator.v1.Etcd instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.Etcd build() {
        Etcd buildable = new Etcd(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EtcdBuilder that = (EtcdBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
