package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.DNSZoneBuilder;
import io.fabric8.openshift.api.model.DNSZone;
import io.fabric8.openshift.api.model.DNSZoneFluentImpl;
import java.util.Collection;
import java.lang.Object;

public class DNSZoneStatusFluentImpl<A extends io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent<A> {

    private java.util.List<io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder>();
    private io.fabric8.openshift.api.model.DNSZoneBuilder dnsZone;

    public DNSZoneStatusFluentImpl() {
    }

    public DNSZoneStatusFluentImpl(io.fabric8.openshift.api.model.operator.v1.DNSZoneStatus instance) {
        this.withConditions(instance.getConditions()); 
        this.withDnsZone(instance.getDnsZone()); 
    }

    public A addToConditions(int index,io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder>();}
        io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder>();}
        io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition... items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder>();}
        for (io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition item : items) {io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition> items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder>();}
        for (io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition item : items) {io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition... items) {
        for (io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition item : items) {io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition> items) {
        for (io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition item : items) {io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConditions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition> getConditions() {
        return build(conditions);
    }

    public java.util.List<io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition> buildConditions() {
        return build(conditions);
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder> predicate) {
        for (io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder> predicate) {
        for (io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(java.util.List<io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder>(); for (io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public java.lang.Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public A addNewCondition(java.lang.String lastTransitionTime,java.lang.String message,java.lang.String reason,java.lang.String status,java.lang.String type) {
        return (A)addToConditions(new DNSZoneCondition(lastTransitionTime, message, reason, status, type));
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.ConditionsNested<A> addNewCondition() {
        return new io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluentImpl.ConditionsNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition item) {
        return new io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluentImpl.ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition item) {
        return new io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluentImpl.ConditionsNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildDnsZone instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.DNSZone getDnsZone() {
        return this.dnsZone!=null?this.dnsZone.build():null;
    }

    public io.fabric8.openshift.api.model.DNSZone buildDnsZone() {
        return this.dnsZone!=null?this.dnsZone.build():null;
    }

    public A withDnsZone(io.fabric8.openshift.api.model.DNSZone dnsZone) {
        _visitables.get("dnsZone").remove(this.dnsZone);
        if (dnsZone!=null){ this.dnsZone= new io.fabric8.openshift.api.model.DNSZoneBuilder(dnsZone); _visitables.get("dnsZone").add(this.dnsZone);} return (A) this;
    }

    public java.lang.Boolean hasDnsZone() {
        return this.dnsZone != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.DnsZoneNested<A> withNewDnsZone() {
        return new io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluentImpl.DnsZoneNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.DnsZoneNested<A> withNewDnsZoneLike(io.fabric8.openshift.api.model.DNSZone item) {
        return new io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluentImpl.DnsZoneNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.DnsZoneNested<A> editDnsZone() {
        return withNewDnsZoneLike(getDnsZone());
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.DnsZoneNested<A> editOrNewDnsZone() {
        return withNewDnsZoneLike(getDnsZone() != null ? getDnsZone(): new io.fabric8.openshift.api.model.DNSZoneBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.DnsZoneNested<A> editOrNewDnsZoneLike(io.fabric8.openshift.api.model.DNSZone item) {
        return withNewDnsZoneLike(getDnsZone() != null ? getDnsZone(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DNSZoneStatusFluentImpl that = (DNSZoneStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (dnsZone != null ? !dnsZone.equals(that.dnsZone) :that.dnsZone != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  dnsZone,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionFluentImpl<io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.ConditionsNested<N>> implements io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSZoneConditionBuilder(this);
                        
            }

            public N and() {
                return (N) DNSZoneStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class DnsZoneNestedImpl<N> extends io.fabric8.openshift.api.model.DNSZoneFluentImpl<io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.DnsZoneNested<N>> implements io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluent.DnsZoneNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.DNSZoneBuilder builder;

            DnsZoneNestedImpl(io.fabric8.openshift.api.model.DNSZone item) {
                this.builder = new io.fabric8.openshift.api.model.DNSZoneBuilder(this, item);
                        
            }

            DnsZoneNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.DNSZoneBuilder(this);
                        
            }

            public N and() {
                return (N) DNSZoneStatusFluentImpl.this.withDnsZone(builder.build());
            }

            public N endDnsZone() {
                return and();
            }
    }


}
