package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleConfigRouteBuilder extends io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRoute,io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteBuilder> {

    io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ConsoleConfigRouteBuilder() {
        this(true);
    }

    public ConsoleConfigRouteBuilder(java.lang.Boolean validationEnabled) {
        this(new ConsoleConfigRoute(), validationEnabled);
    }

    public ConsoleConfigRouteBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteFluent<?> fluent) {
        this(fluent, true);
    }

    public ConsoleConfigRouteBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ConsoleConfigRoute(), validationEnabled);
    }

    public ConsoleConfigRouteBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRoute instance) {
        this(fluent, instance, true);
    }

    public ConsoleConfigRouteBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRoute instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHostname(instance.getHostname()); 
        fluent.withSecret(instance.getSecret()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleConfigRouteBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRoute instance) {
        this(instance,true);
    }

    public ConsoleConfigRouteBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRoute instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withHostname(instance.getHostname()); 
        this.withSecret(instance.getSecret()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRoute build() {
        ConsoleConfigRoute buildable = new ConsoleConfigRoute(fluent.getHostname(),fluent.getSecret());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleConfigRouteBuilder that = (ConsoleConfigRouteBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
