package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterNetworkEntryBuilder extends io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryFluentImpl<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry,io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> {

    io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ClusterNetworkEntryBuilder() {
        this(true);
    }

    public ClusterNetworkEntryBuilder(java.lang.Boolean validationEnabled) {
        this(new ClusterNetworkEntry(), validationEnabled);
    }

    public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ClusterNetworkEntry(), validationEnabled);
    }

    public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry instance) {
        this(fluent, instance, true);
    }

    public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCidr(instance.getCidr()); 
        fluent.withHostPrefix(instance.getHostPrefix()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry instance) {
        this(instance,true);
    }

    public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCidr(instance.getCidr()); 
        this.withHostPrefix(instance.getHostPrefix()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry build() {
        ClusterNetworkEntry buildable = new ClusterNetworkEntry(fluent.getCidr(),fluent.getHostPrefix());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterNetworkEntryBuilder that = (ClusterNetworkEntryBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
