package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterCSIDriverBuilder extends io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverFluentImpl<io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver,io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverBuilder> {

    io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ClusterCSIDriverBuilder() {
        this(true);
    }

    public ClusterCSIDriverBuilder(java.lang.Boolean validationEnabled) {
        this(new ClusterCSIDriver(), validationEnabled);
    }

    public ClusterCSIDriverBuilder(io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterCSIDriverBuilder(io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ClusterCSIDriver(), validationEnabled);
    }

    public ClusterCSIDriverBuilder(io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver instance) {
        this(fluent, instance, true);
    }

    public ClusterCSIDriverBuilder(io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterCSIDriverBuilder(io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver instance) {
        this(instance,true);
    }

    public ClusterCSIDriverBuilder(io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver build() {
        ClusterCSIDriver buildable = new ClusterCSIDriver(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterCSIDriverBuilder that = (ClusterCSIDriverBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
