package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CloudCredentialStatusBuilder extends io.fabric8.openshift.api.model.operator.v1.CloudCredentialStatusFluentImpl<io.fabric8.openshift.api.model.operator.v1.CloudCredentialStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.CloudCredentialStatus,io.fabric8.openshift.api.model.operator.v1.CloudCredentialStatusBuilder> {

    io.fabric8.openshift.api.model.operator.v1.CloudCredentialStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public CloudCredentialStatusBuilder() {
        this(true);
    }

    public CloudCredentialStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new CloudCredentialStatus(), validationEnabled);
    }

    public CloudCredentialStatusBuilder(io.fabric8.openshift.api.model.operator.v1.CloudCredentialStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public CloudCredentialStatusBuilder(io.fabric8.openshift.api.model.operator.v1.CloudCredentialStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new CloudCredentialStatus(), validationEnabled);
    }

    public CloudCredentialStatusBuilder(io.fabric8.openshift.api.model.operator.v1.CloudCredentialStatusFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.CloudCredentialStatus instance) {
        this(fluent, instance, true);
    }

    public CloudCredentialStatusBuilder(io.fabric8.openshift.api.model.operator.v1.CloudCredentialStatusFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.CloudCredentialStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withGenerations(instance.getGenerations()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withReadyReplicas(instance.getReadyReplicas()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public CloudCredentialStatusBuilder(io.fabric8.openshift.api.model.operator.v1.CloudCredentialStatus instance) {
        this(instance,true);
    }

    public CloudCredentialStatusBuilder(io.fabric8.openshift.api.model.operator.v1.CloudCredentialStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withGenerations(instance.getGenerations()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReadyReplicas(instance.getReadyReplicas()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.CloudCredentialStatus build() {
        CloudCredentialStatus buildable = new CloudCredentialStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CloudCredentialStatusBuilder that = (CloudCredentialStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
