package io.fabric8.openshift.api.model.operator.controlplane.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodNetworkConnectivityCheckSpecBuilder extends io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecFluentImpl<io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpec,io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecBuilder> {

    io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PodNetworkConnectivityCheckSpecBuilder() {
        this(true);
    }

    public PodNetworkConnectivityCheckSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new PodNetworkConnectivityCheckSpec(), validationEnabled);
    }

    public PodNetworkConnectivityCheckSpecBuilder(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public PodNetworkConnectivityCheckSpecBuilder(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PodNetworkConnectivityCheckSpec(), validationEnabled);
    }

    public PodNetworkConnectivityCheckSpecBuilder(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecFluent<?> fluent,io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpec instance) {
        this(fluent, instance, true);
    }

    public PodNetworkConnectivityCheckSpecBuilder(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecFluent<?> fluent,io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSourcePod(instance.getSourcePod()); 
        fluent.withTargetEndpoint(instance.getTargetEndpoint()); 
        fluent.withTlsClientCert(instance.getTlsClientCert()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodNetworkConnectivityCheckSpecBuilder(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpec instance) {
        this(instance,true);
    }

    public PodNetworkConnectivityCheckSpecBuilder(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withSourcePod(instance.getSourcePod()); 
        this.withTargetEndpoint(instance.getTargetEndpoint()); 
        this.withTlsClientCert(instance.getTlsClientCert()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpec build() {
        PodNetworkConnectivityCheckSpec buildable = new PodNetworkConnectivityCheckSpec(fluent.getSourcePod(),fluent.getTargetEndpoint(),fluent.getTlsClientCert());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodNetworkConnectivityCheckSpecBuilder that = (PodNetworkConnectivityCheckSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
