package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StaticIPAMDNSBuilder extends StaticIPAMDNSFluentImpl<StaticIPAMDNSBuilder> implements VisitableBuilder<StaticIPAMDNS,StaticIPAMDNSBuilder> {

    StaticIPAMDNSFluent<?> fluent;
    Boolean validationEnabled;

    public StaticIPAMDNSBuilder() {
        this(true);
    }

    public StaticIPAMDNSBuilder(Boolean validationEnabled) {
        this(new StaticIPAMDNS(), validationEnabled);
    }

    public StaticIPAMDNSBuilder(StaticIPAMDNSFluent<?> fluent) {
        this(fluent, true);
    }

    public StaticIPAMDNSBuilder(StaticIPAMDNSFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new StaticIPAMDNS(), validationEnabled);
    }

    public StaticIPAMDNSBuilder(StaticIPAMDNSFluent<?> fluent,StaticIPAMDNS instance) {
        this(fluent, instance, true);
    }

    public StaticIPAMDNSBuilder(StaticIPAMDNSFluent<?> fluent,StaticIPAMDNS instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDomain(instance.getDomain()); 
        fluent.withNameservers(instance.getNameservers()); 
        fluent.withSearch(instance.getSearch()); 
        this.validationEnabled = validationEnabled; 
    }

    public StaticIPAMDNSBuilder(StaticIPAMDNS instance) {
        this(instance,true);
    }

    public StaticIPAMDNSBuilder(StaticIPAMDNS instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDomain(instance.getDomain()); 
        this.withNameservers(instance.getNameservers()); 
        this.withSearch(instance.getSearch()); 
        this.validationEnabled = validationEnabled; 
    }

    public StaticIPAMDNS build() {
        StaticIPAMDNS buildable = new StaticIPAMDNS(fluent.getDomain(),fluent.getNameservers(),fluent.getSearch());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StaticIPAMDNSBuilder that = (StaticIPAMDNSBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
