package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class SimpleMacvlanConfigFluentImpl<A extends SimpleMacvlanConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SimpleMacvlanConfigFluent<A> {

    private IPAMConfigBuilder ipamConfig;
    private String master;
    private String mode;
    private Integer mtu;

    public SimpleMacvlanConfigFluentImpl() {
    }

    public SimpleMacvlanConfigFluentImpl(SimpleMacvlanConfig instance) {
        this.withIpamConfig(instance.getIpamConfig()); 
        this.withMaster(instance.getMaster()); 
        this.withMode(instance.getMode()); 
        this.withMtu(instance.getMtu()); 
    }

    
/**
 * This method has been deprecated, please use method buildIpamConfig instead.
 * @return The buildable object.
 */
@Deprecated public IPAMConfig getIpamConfig() {
        return this.ipamConfig!=null?this.ipamConfig.build():null;
    }

    public IPAMConfig buildIpamConfig() {
        return this.ipamConfig!=null?this.ipamConfig.build():null;
    }

    public A withIpamConfig(IPAMConfig ipamConfig) {
        _visitables.get("ipamConfig").remove(this.ipamConfig);
        if (ipamConfig!=null){ this.ipamConfig= new IPAMConfigBuilder(ipamConfig); _visitables.get("ipamConfig").add(this.ipamConfig);} return (A) this;
    }

    public Boolean hasIpamConfig() {
        return this.ipamConfig != null;
    }

    public SimpleMacvlanConfigFluent.IpamConfigNested<A> withNewIpamConfig() {
        return new IpamConfigNestedImpl();
    }

    public SimpleMacvlanConfigFluent.IpamConfigNested<A> withNewIpamConfigLike(IPAMConfig item) {
        return new IpamConfigNestedImpl(item);
    }

    public SimpleMacvlanConfigFluent.IpamConfigNested<A> editIpamConfig() {
        return withNewIpamConfigLike(getIpamConfig());
    }

    public SimpleMacvlanConfigFluent.IpamConfigNested<A> editOrNewIpamConfig() {
        return withNewIpamConfigLike(getIpamConfig() != null ? getIpamConfig(): new IPAMConfigBuilder().build());
    }

    public SimpleMacvlanConfigFluent.IpamConfigNested<A> editOrNewIpamConfigLike(IPAMConfig item) {
        return withNewIpamConfigLike(getIpamConfig() != null ? getIpamConfig(): item);
    }

    public String getMaster() {
        return this.master;
    }

    public A withMaster(String master) {
        this.master=master; return (A) this;
    }

    public Boolean hasMaster() {
        return this.master != null;
    }

    public A withNewMaster(String arg1) {
        return (A)withMaster(new String(arg1));
    }

    public A withNewMaster(StringBuilder arg1) {
        return (A)withMaster(new String(arg1));
    }

    public A withNewMaster(StringBuffer arg1) {
        return (A)withMaster(new String(arg1));
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode=mode; return (A) this;
    }

    public Boolean hasMode() {
        return this.mode != null;
    }

    public A withNewMode(String arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuilder arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuffer arg1) {
        return (A)withMode(new String(arg1));
    }

    public Integer getMtu() {
        return this.mtu;
    }

    public A withMtu(Integer mtu) {
        this.mtu=mtu; return (A) this;
    }

    public Boolean hasMtu() {
        return this.mtu != null;
    }

    public A withNewMtu(String arg1) {
        return (A)withMtu(new Integer(arg1));
    }

    public A withNewMtu(int arg1) {
        return (A)withMtu(new Integer(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SimpleMacvlanConfigFluentImpl that = (SimpleMacvlanConfigFluentImpl) o;
        if (ipamConfig != null ? !ipamConfig.equals(that.ipamConfig) :that.ipamConfig != null) return false;
        if (master != null ? !master.equals(that.master) :that.master != null) return false;
        if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
        if (mtu != null ? !mtu.equals(that.mtu) :that.mtu != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ipamConfig,  master,  mode,  mtu,  super.hashCode());
    }

    public class IpamConfigNestedImpl<N> extends IPAMConfigFluentImpl<SimpleMacvlanConfigFluent.IpamConfigNested<N>> implements SimpleMacvlanConfigFluent.IpamConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IPAMConfigBuilder builder;

            IpamConfigNestedImpl(IPAMConfig item) {
                this.builder = new IPAMConfigBuilder(this, item);
                        
            }

            IpamConfigNestedImpl() {
                this.builder = new IPAMConfigBuilder(this);
                        
            }

            public N and() {
                return (N) SimpleMacvlanConfigFluentImpl.this.withIpamConfig(builder.build());
            }

            public N endIpamConfig() {
                return and();
            }
    }


}
