package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OperatorConditionBuilder extends OperatorConditionFluentImpl<OperatorConditionBuilder> implements VisitableBuilder<OperatorCondition,OperatorConditionBuilder> {

    OperatorConditionFluent<?> fluent;
    Boolean validationEnabled;

    public OperatorConditionBuilder() {
        this(true);
    }

    public OperatorConditionBuilder(Boolean validationEnabled) {
        this(new OperatorCondition(), validationEnabled);
    }

    public OperatorConditionBuilder(OperatorConditionFluent<?> fluent) {
        this(fluent, true);
    }

    public OperatorConditionBuilder(OperatorConditionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new OperatorCondition(), validationEnabled);
    }

    public OperatorConditionBuilder(OperatorConditionFluent<?> fluent,OperatorCondition instance) {
        this(fluent, instance, true);
    }

    public OperatorConditionBuilder(OperatorConditionFluent<?> fluent,OperatorCondition instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public OperatorConditionBuilder(OperatorCondition instance) {
        this(instance,true);
    }

    public OperatorConditionBuilder(OperatorCondition instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withMessage(instance.getMessage()); 
        this.withReason(instance.getReason()); 
        this.withStatus(instance.getStatus()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public OperatorCondition build() {
        OperatorCondition buildable = new OperatorCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OperatorConditionBuilder that = (OperatorConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
