package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OVNKubernetesConfigBuilder extends OVNKubernetesConfigFluentImpl<OVNKubernetesConfigBuilder> implements VisitableBuilder<OVNKubernetesConfig,OVNKubernetesConfigBuilder> {

    OVNKubernetesConfigFluent<?> fluent;
    Boolean validationEnabled;

    public OVNKubernetesConfigBuilder() {
        this(true);
    }

    public OVNKubernetesConfigBuilder(Boolean validationEnabled) {
        this(new OVNKubernetesConfig(), validationEnabled);
    }

    public OVNKubernetesConfigBuilder(OVNKubernetesConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public OVNKubernetesConfigBuilder(OVNKubernetesConfigFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new OVNKubernetesConfig(), validationEnabled);
    }

    public OVNKubernetesConfigBuilder(OVNKubernetesConfigFluent<?> fluent,OVNKubernetesConfig instance) {
        this(fluent, instance, true);
    }

    public OVNKubernetesConfigBuilder(OVNKubernetesConfigFluent<?> fluent,OVNKubernetesConfig instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withGenevePort(instance.getGenevePort()); 
        fluent.withHybridOverlayConfig(instance.getHybridOverlayConfig()); 
        fluent.withMtu(instance.getMtu()); 
        this.validationEnabled = validationEnabled; 
    }

    public OVNKubernetesConfigBuilder(OVNKubernetesConfig instance) {
        this(instance,true);
    }

    public OVNKubernetesConfigBuilder(OVNKubernetesConfig instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withGenevePort(instance.getGenevePort()); 
        this.withHybridOverlayConfig(instance.getHybridOverlayConfig()); 
        this.withMtu(instance.getMtu()); 
        this.validationEnabled = validationEnabled; 
    }

    public OVNKubernetesConfig build() {
        OVNKubernetesConfig buildable = new OVNKubernetesConfig(fluent.getGenevePort(),fluent.getHybridOverlayConfig(),fluent.getMtu());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OVNKubernetesConfigBuilder that = (OVNKubernetesConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
