package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImagePrunerBuilder extends ImagePrunerFluentImpl<ImagePrunerBuilder> implements VisitableBuilder<ImagePruner,ImagePrunerBuilder> {

    ImagePrunerFluent<?> fluent;
    Boolean validationEnabled;

    public ImagePrunerBuilder() {
        this(true);
    }

    public ImagePrunerBuilder(Boolean validationEnabled) {
        this(new ImagePruner(), validationEnabled);
    }

    public ImagePrunerBuilder(ImagePrunerFluent<?> fluent) {
        this(fluent, true);
    }

    public ImagePrunerBuilder(ImagePrunerFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ImagePruner(), validationEnabled);
    }

    public ImagePrunerBuilder(ImagePrunerFluent<?> fluent,ImagePruner instance) {
        this(fluent, instance, true);
    }

    public ImagePrunerBuilder(ImagePrunerFluent<?> fluent,ImagePruner instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImagePrunerBuilder(ImagePruner instance) {
        this(instance,true);
    }

    public ImagePrunerBuilder(ImagePruner instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImagePruner build() {
        ImagePruner buildable = new ImagePruner(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ImagePrunerBuilder that = (ImagePrunerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
