package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DNSZoneStatusBuilder extends DNSZoneStatusFluentImpl<DNSZoneStatusBuilder> implements VisitableBuilder<DNSZoneStatus,DNSZoneStatusBuilder> {

    DNSZoneStatusFluent<?> fluent;
    Boolean validationEnabled;

    public DNSZoneStatusBuilder() {
        this(true);
    }

    public DNSZoneStatusBuilder(Boolean validationEnabled) {
        this(new DNSZoneStatus(), validationEnabled);
    }

    public DNSZoneStatusBuilder(DNSZoneStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public DNSZoneStatusBuilder(DNSZoneStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new DNSZoneStatus(), validationEnabled);
    }

    public DNSZoneStatusBuilder(DNSZoneStatusFluent<?> fluent,DNSZoneStatus instance) {
        this(fluent, instance, true);
    }

    public DNSZoneStatusBuilder(DNSZoneStatusFluent<?> fluent,DNSZoneStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withDnsZone(instance.getDnsZone()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSZoneStatusBuilder(DNSZoneStatus instance) {
        this(instance,true);
    }

    public DNSZoneStatusBuilder(DNSZoneStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withDnsZone(instance.getDnsZone()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSZoneStatus build() {
        DNSZoneStatus buildable = new DNSZoneStatus(fluent.getConditions(),fluent.getDnsZone());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DNSZoneStatusBuilder that = (DNSZoneStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
