package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DNSRecordListBuilder extends DNSRecordListFluentImpl<DNSRecordListBuilder> implements VisitableBuilder<DNSRecordList,DNSRecordListBuilder> {

    DNSRecordListFluent<?> fluent;
    Boolean validationEnabled;

    public DNSRecordListBuilder() {
        this(true);
    }

    public DNSRecordListBuilder(Boolean validationEnabled) {
        this(new DNSRecordList(), validationEnabled);
    }

    public DNSRecordListBuilder(DNSRecordListFluent<?> fluent) {
        this(fluent, true);
    }

    public DNSRecordListBuilder(DNSRecordListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new DNSRecordList(), validationEnabled);
    }

    public DNSRecordListBuilder(DNSRecordListFluent<?> fluent,DNSRecordList instance) {
        this(fluent, instance, true);
    }

    public DNSRecordListBuilder(DNSRecordListFluent<?> fluent,DNSRecordList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSRecordListBuilder(DNSRecordList instance) {
        this(instance,true);
    }

    public DNSRecordListBuilder(DNSRecordList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSRecordList build() {
        DNSRecordList buildable = new DNSRecordList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DNSRecordListBuilder that = (DNSRecordListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
