package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageContentSourcePolicyListBuilder extends ImageContentSourcePolicyListFluentImpl<ImageContentSourcePolicyListBuilder> implements VisitableBuilder<ImageContentSourcePolicyList,ImageContentSourcePolicyListBuilder> {

    ImageContentSourcePolicyListFluent<?> fluent;
    Boolean validationEnabled;

    public ImageContentSourcePolicyListBuilder() {
        this(true);
    }

    public ImageContentSourcePolicyListBuilder(Boolean validationEnabled) {
        this(new ImageContentSourcePolicyList(), validationEnabled);
    }

    public ImageContentSourcePolicyListBuilder(ImageContentSourcePolicyListFluent<?> fluent) {
        this(fluent, true);
    }

    public ImageContentSourcePolicyListBuilder(ImageContentSourcePolicyListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ImageContentSourcePolicyList(), validationEnabled);
    }

    public ImageContentSourcePolicyListBuilder(ImageContentSourcePolicyListFluent<?> fluent,ImageContentSourcePolicyList instance) {
        this(fluent, instance, true);
    }

    public ImageContentSourcePolicyListBuilder(ImageContentSourcePolicyListFluent<?> fluent,ImageContentSourcePolicyList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImageContentSourcePolicyListBuilder(ImageContentSourcePolicyList instance) {
        this(instance,true);
    }

    public ImageContentSourcePolicyListBuilder(ImageContentSourcePolicyList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImageContentSourcePolicyList build() {
        ImageContentSourcePolicyList buildable = new ImageContentSourcePolicyList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ImageContentSourcePolicyListBuilder that = (ImageContentSourcePolicyListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
