package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StatuspageProviderBuilder extends StatuspageProviderFluentImpl<StatuspageProviderBuilder> implements VisitableBuilder<StatuspageProvider,StatuspageProviderBuilder> {

    StatuspageProviderFluent<?> fluent;
    Boolean validationEnabled;

    public StatuspageProviderBuilder() {
        this(true);
    }

    public StatuspageProviderBuilder(Boolean validationEnabled) {
        this(new StatuspageProvider(), validationEnabled);
    }

    public StatuspageProviderBuilder(StatuspageProviderFluent<?> fluent) {
        this(fluent, true);
    }

    public StatuspageProviderBuilder(StatuspageProviderFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new StatuspageProvider(), validationEnabled);
    }

    public StatuspageProviderBuilder(StatuspageProviderFluent<?> fluent,StatuspageProvider instance) {
        this(fluent, instance, true);
    }

    public StatuspageProviderBuilder(StatuspageProviderFluent<?> fluent,StatuspageProvider instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPageID(instance.getPageID()); 
        this.validationEnabled = validationEnabled; 
    }

    public StatuspageProviderBuilder(StatuspageProvider instance) {
        this(instance,true);
    }

    public StatuspageProviderBuilder(StatuspageProvider instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withPageID(instance.getPageID()); 
        this.validationEnabled = validationEnabled; 
    }

    public StatuspageProvider build() {
        StatuspageProvider buildable = new StatuspageProvider(fluent.getPageID());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StatuspageProviderBuilder that = (StatuspageProviderBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
