package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OpenShiftControllerManagerStatusBuilder extends OpenShiftControllerManagerStatusFluentImpl<OpenShiftControllerManagerStatusBuilder> implements VisitableBuilder<OpenShiftControllerManagerStatus,OpenShiftControllerManagerStatusBuilder> {

    OpenShiftControllerManagerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public OpenShiftControllerManagerStatusBuilder() {
        this(true);
    }

    public OpenShiftControllerManagerStatusBuilder(Boolean validationEnabled) {
        this(new OpenShiftControllerManagerStatus(), validationEnabled);
    }

    public OpenShiftControllerManagerStatusBuilder(OpenShiftControllerManagerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public OpenShiftControllerManagerStatusBuilder(OpenShiftControllerManagerStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new OpenShiftControllerManagerStatus(), validationEnabled);
    }

    public OpenShiftControllerManagerStatusBuilder(OpenShiftControllerManagerStatusFluent<?> fluent,OpenShiftControllerManagerStatus instance) {
        this(fluent, instance, true);
    }

    public OpenShiftControllerManagerStatusBuilder(OpenShiftControllerManagerStatusFluent<?> fluent,OpenShiftControllerManagerStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withGenerations(instance.getGenerations()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withReadyReplicas(instance.getReadyReplicas()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public OpenShiftControllerManagerStatusBuilder(OpenShiftControllerManagerStatus instance) {
        this(instance,true);
    }

    public OpenShiftControllerManagerStatusBuilder(OpenShiftControllerManagerStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withGenerations(instance.getGenerations()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReadyReplicas(instance.getReadyReplicas()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public OpenShiftControllerManagerStatus build() {
        OpenShiftControllerManagerStatus buildable = new OpenShiftControllerManagerStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OpenShiftControllerManagerStatusBuilder that = (OpenShiftControllerManagerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
