package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NodePortStrategyBuilder extends NodePortStrategyFluentImpl<NodePortStrategyBuilder> implements VisitableBuilder<NodePortStrategy,NodePortStrategyBuilder> {

    NodePortStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public NodePortStrategyBuilder() {
        this(true);
    }

    public NodePortStrategyBuilder(Boolean validationEnabled) {
        this(new NodePortStrategy(), validationEnabled);
    }

    public NodePortStrategyBuilder(NodePortStrategyFluent<?> fluent) {
        this(fluent, true);
    }

    public NodePortStrategyBuilder(NodePortStrategyFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new NodePortStrategy(), validationEnabled);
    }

    public NodePortStrategyBuilder(NodePortStrategyFluent<?> fluent,NodePortStrategy instance) {
        this(fluent, instance, true);
    }

    public NodePortStrategyBuilder(NodePortStrategyFluent<?> fluent,NodePortStrategy instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public NodePortStrategyBuilder(NodePortStrategy instance) {
        this(instance,true);
    }

    public NodePortStrategyBuilder(NodePortStrategy instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public NodePortStrategy build() {
        NodePortStrategy buildable = new NodePortStrategy();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NodePortStrategyBuilder that = (NodePortStrategyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
