package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.openshift.api.model.TLSProfileSpecFluent;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.openshift.api.model.TLSProfileSpec;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.openshift.api.model.TLSProfileSpecBuilder;

public interface IngressControllerStatusFluent<A extends IngressControllerStatusFluent<A>> extends Fluent<A> {


    public Integer getAvailableReplicas();
    public A withAvailableReplicas(Integer availableReplicas);
    public Boolean hasAvailableReplicas();
    public A withNewAvailableReplicas(String arg1);
    public A withNewAvailableReplicas(int arg1);
    public A addToConditions(int index,OperatorCondition item);
    public A setToConditions(int index,OperatorCondition item);
    public A addToConditions(OperatorCondition... items);
    public A addAllToConditions(Collection<OperatorCondition> items);
    public A removeFromConditions(OperatorCondition... items);
    public A removeAllFromConditions(Collection<OperatorCondition> items);
    public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<OperatorCondition> getConditions();
    public List<OperatorCondition> buildConditions();
    public OperatorCondition buildCondition(int index);
    public OperatorCondition buildFirstCondition();
    public OperatorCondition buildLastCondition();
    public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
    public A withConditions(List<OperatorCondition> conditions);
    public A withConditions(OperatorCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public IngressControllerStatusFluent.ConditionsNested<A> addNewCondition();
    public IngressControllerStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item);
    public IngressControllerStatusFluent.ConditionsNested<A> setNewConditionLike(int index,OperatorCondition item);
    public IngressControllerStatusFluent.ConditionsNested<A> editCondition(int index);
    public IngressControllerStatusFluent.ConditionsNested<A> editFirstCondition();
    public IngressControllerStatusFluent.ConditionsNested<A> editLastCondition();
    public IngressControllerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
    public String getDomain();
    public A withDomain(String domain);
    public Boolean hasDomain();
    public A withNewDomain(String arg1);
    public A withNewDomain(StringBuilder arg1);
    public A withNewDomain(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildEndpointPublishingStrategy instead.
 * @return The buildable object.
 */
@Deprecated public EndpointPublishingStrategy getEndpointPublishingStrategy();
    public EndpointPublishingStrategy buildEndpointPublishingStrategy();
    public A withEndpointPublishingStrategy(EndpointPublishingStrategy endpointPublishingStrategy);
    public Boolean hasEndpointPublishingStrategy();
    public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategy();
    public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item);
    public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editEndpointPublishingStrategy();
    public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategy();
    public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(String arg1);
    public A withNewObservedGeneration(long arg1);
    public String getSelector();
    public A withSelector(String selector);
    public Boolean hasSelector();
    public A withNewSelector(String arg1);
    public A withNewSelector(StringBuilder arg1);
    public A withNewSelector(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTlsProfile instead.
 * @return The buildable object.
 */
@Deprecated public TLSProfileSpec getTlsProfile();
    public TLSProfileSpec buildTlsProfile();
    public A withTlsProfile(TLSProfileSpec tlsProfile);
    public Boolean hasTlsProfile();
    public IngressControllerStatusFluent.TlsProfileNested<A> withNewTlsProfile();
    public IngressControllerStatusFluent.TlsProfileNested<A> withNewTlsProfileLike(TLSProfileSpec item);
    public IngressControllerStatusFluent.TlsProfileNested<A> editTlsProfile();
    public IngressControllerStatusFluent.TlsProfileNested<A> editOrNewTlsProfile();
    public IngressControllerStatusFluent.TlsProfileNested<A> editOrNewTlsProfileLike(TLSProfileSpec item);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorConditionFluent<IngressControllerStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface EndpointPublishingStrategyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointPublishingStrategyFluent<IngressControllerStatusFluent.EndpointPublishingStrategyNested<N>> {

            public N and();
            public N endEndpointPublishingStrategy();    }


    public interface TlsProfileNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TLSProfileSpecFluent<IngressControllerStatusFluent.TlsProfileNested<N>> {

            public N and();
            public N endTlsProfile();    }


}
