package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ForwardPluginBuilder extends ForwardPluginFluentImpl<ForwardPluginBuilder> implements VisitableBuilder<ForwardPlugin,ForwardPluginBuilder> {

    ForwardPluginFluent<?> fluent;
    Boolean validationEnabled;

    public ForwardPluginBuilder() {
        this(true);
    }

    public ForwardPluginBuilder(Boolean validationEnabled) {
        this(new ForwardPlugin(), validationEnabled);
    }

    public ForwardPluginBuilder(ForwardPluginFluent<?> fluent) {
        this(fluent, true);
    }

    public ForwardPluginBuilder(ForwardPluginFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ForwardPlugin(), validationEnabled);
    }

    public ForwardPluginBuilder(ForwardPluginFluent<?> fluent,ForwardPlugin instance) {
        this(fluent, instance, true);
    }

    public ForwardPluginBuilder(ForwardPluginFluent<?> fluent,ForwardPlugin instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withUpstreams(instance.getUpstreams()); 
        this.validationEnabled = validationEnabled; 
    }

    public ForwardPluginBuilder(ForwardPlugin instance) {
        this(instance,true);
    }

    public ForwardPluginBuilder(ForwardPlugin instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withUpstreams(instance.getUpstreams()); 
        this.validationEnabled = validationEnabled; 
    }

    public ForwardPlugin build() {
        ForwardPlugin buildable = new ForwardPlugin(fluent.getUpstreams());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ForwardPluginBuilder that = (ForwardPluginBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
