package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class StaticIPAMConfigFluentImpl<A extends io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent<A>{
  public StaticIPAMConfigFluentImpl() {
  }
  public StaticIPAMConfigFluentImpl(io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfig instance) {
    this.withAddresses(instance.getAddresses()); 
    this.withDns(instance.getDns()); 
    this.withRoutes(instance.getRoutes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder> addresses =  new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder>();
  private io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNSBuilder dns;
  private java.util.List<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder> routes =  new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToAddresses(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses item) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder>();}
    io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder(item);_visitables.get("addresses").add(index >= 0 ? index : _visitables.get("addresses").size(), builder);this.addresses.add(index >= 0 ? index : addresses.size(), builder); return (A)this;
  }
  public A setToAddresses(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses item) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder>();}
    io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder(item);
    if (index < 0 || index >= _visitables.get("addresses").size()) { _visitables.get("addresses").add(builder); } else { _visitables.get("addresses").set(index, builder);}
    if (index < 0 || index >= addresses.size()) { addresses.add(builder); } else { addresses.set(index, builder);}
     return (A)this;
  }
  public A addToAddresses(io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses... items) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder>();}
    for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses item : items) {io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A addAllToAddresses(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses> items) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder>();}
    for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses item : items) {io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A removeFromAddresses(io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses... items) {
    for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses item : items) {io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
  }
  public A removeAllFromAddresses(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses> items) {
    for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses item : items) {io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAddresses(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder> predicate) {
    if (addresses == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder> each = addresses.iterator();
    final List visitables = _visitables.get("addresses");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAddresses instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses> getAddresses() {
    return build(addresses);
  }
  public java.util.List<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses> buildAddresses() {
    return build(addresses);
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses buildAddress(java.lang.Integer index) {
    return this.addresses.get(index).build();
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses buildFirstAddress() {
    return this.addresses.get(0).build();
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses buildLastAddress() {
    return this.addresses.get(addresses.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses buildMatchingAddress(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder> predicate) {
    for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder item: addresses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingAddress(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder> predicate) {
    for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder item: addresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAddresses(java.util.List<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses> addresses) {
    if (this.addresses != null) { _visitables.get("addresses").removeAll(this.addresses);}
    if (addresses != null) {this.addresses = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder>(); for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
  }
  public A withAddresses(io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses... addresses) {
    if (this.addresses != null) {this.addresses.clear();}
    if (addresses != null) {for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  public java.lang.Boolean hasAddresses() {
    return addresses != null && !addresses.isEmpty();
  }
  public A addNewAddress(java.lang.String address,java.lang.String gateway) {
    return (A)addToAddresses(new StaticIPAMAddresses(address, gateway));
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<A> addNewAddress() {
    return new io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluentImpl.AddressesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<A> addNewAddressLike(io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses item) {
    return new io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluentImpl.AddressesNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<A> setNewAddressLike(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses item) {
    return new io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluentImpl.AddressesNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<A> editAddress(java.lang.Integer index) {
    if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<A> editFirstAddress() {
    if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
    return setNewAddressLike(0, buildAddress(0));
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<A> editLastAddress() {
    int index = addresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<A> editMatchingAddress(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<addresses.size();i++) { 
    if (predicate.test(addresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
    return setNewAddressLike(index, buildAddress(index));
  }
  
  /**
   * This method has been deprecated, please use method buildDns instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNS getDns() {
    return this.dns!=null?this.dns.build():null;
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNS buildDns() {
    return this.dns!=null?this.dns.build():null;
  }
  public A withDns(io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNS dns) {
    _visitables.get("dns").remove(this.dns);
    if (dns!=null){ this.dns= new io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNSBuilder(dns); _visitables.get("dns").add(this.dns);} return (A) this;
  }
  public java.lang.Boolean hasDns() {
    return this.dns != null;
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.DnsNested<A> withNewDns() {
    return new io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluentImpl.DnsNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.DnsNested<A> withNewDnsLike(io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNS item) {
    return new io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluentImpl.DnsNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.DnsNested<A> editDns() {
    return withNewDnsLike(getDns());
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.DnsNested<A> editOrNewDns() {
    return withNewDnsLike(getDns() != null ? getDns(): new io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNSBuilder().build());
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.DnsNested<A> editOrNewDnsLike(io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNS item) {
    return withNewDnsLike(getDns() != null ? getDns(): item);
  }
  public A addToRoutes(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes item) {
    if (this.routes == null) {this.routes = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder>();}
    io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder(item);_visitables.get("routes").add(index >= 0 ? index : _visitables.get("routes").size(), builder);this.routes.add(index >= 0 ? index : routes.size(), builder); return (A)this;
  }
  public A setToRoutes(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes item) {
    if (this.routes == null) {this.routes = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder>();}
    io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder(item);
    if (index < 0 || index >= _visitables.get("routes").size()) { _visitables.get("routes").add(builder); } else { _visitables.get("routes").set(index, builder);}
    if (index < 0 || index >= routes.size()) { routes.add(builder); } else { routes.set(index, builder);}
     return (A)this;
  }
  public A addToRoutes(io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes... items) {
    if (this.routes == null) {this.routes = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder>();}
    for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes item : items) {io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder(item);_visitables.get("routes").add(builder);this.routes.add(builder);} return (A)this;
  }
  public A addAllToRoutes(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes> items) {
    if (this.routes == null) {this.routes = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder>();}
    for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes item : items) {io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder(item);_visitables.get("routes").add(builder);this.routes.add(builder);} return (A)this;
  }
  public A removeFromRoutes(io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes... items) {
    for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes item : items) {io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder(item);_visitables.get("routes").remove(builder);if (this.routes != null) {this.routes.remove(builder);}} return (A)this;
  }
  public A removeAllFromRoutes(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes> items) {
    for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes item : items) {io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder(item);_visitables.get("routes").remove(builder);if (this.routes != null) {this.routes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRoutes(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder> predicate) {
    if (routes == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder> each = routes.iterator();
    final List visitables = _visitables.get("routes");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRoutes instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes> getRoutes() {
    return build(routes);
  }
  public java.util.List<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes> buildRoutes() {
    return build(routes);
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes buildRoute(java.lang.Integer index) {
    return this.routes.get(index).build();
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes buildFirstRoute() {
    return this.routes.get(0).build();
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes buildLastRoute() {
    return this.routes.get(routes.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes buildMatchingRoute(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder> predicate) {
    for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder item: routes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingRoute(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder> predicate) {
    for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder item: routes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRoutes(java.util.List<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes> routes) {
    if (this.routes != null) { _visitables.get("routes").removeAll(this.routes);}
    if (routes != null) {this.routes = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder>(); for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes item : routes){this.addToRoutes(item);}} else { this.routes = null;} return (A) this;
  }
  public A withRoutes(io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes... routes) {
    if (this.routes != null) {this.routes.clear();}
    if (routes != null) {for (io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes item :routes){ this.addToRoutes(item);}} return (A) this;
  }
  public java.lang.Boolean hasRoutes() {
    return routes != null && !routes.isEmpty();
  }
  public A addNewRoute(java.lang.String destination,java.lang.String gateway) {
    return (A)addToRoutes(new StaticIPAMRoutes(destination, gateway));
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<A> addNewRoute() {
    return new io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluentImpl.RoutesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<A> addNewRouteLike(io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes item) {
    return new io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluentImpl.RoutesNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<A> setNewRouteLike(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes item) {
    return new io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluentImpl.RoutesNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<A> editRoute(java.lang.Integer index) {
    if (routes.size() <= index) throw new RuntimeException("Can't edit routes. Index exceeds size.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<A> editFirstRoute() {
    if (routes.size() == 0) throw new RuntimeException("Can't edit first routes. The list is empty.");
    return setNewRouteLike(0, buildRoute(0));
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<A> editLastRoute() {
    int index = routes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last routes. The list is empty.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<A> editMatchingRoute(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<routes.size();i++) { 
    if (predicate.test(routes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching routes. No match found.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StaticIPAMConfigFluentImpl that = (StaticIPAMConfigFluentImpl) o;
    if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
    if (dns != null ? !dns.equals(that.dns) :that.dns != null) return false;
    if (routes != null ? !routes.equals(that.routes) :that.routes != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addresses,  dns,  routes,  additionalProperties,  super.hashCode());
  }
  public class AddressesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesFluentImpl<io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AddressesNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder(this, item);
    }
    AddressesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) StaticIPAMConfigFluentImpl.this.setToAddresses(index,builder.build());
    }
    public N endAddress() {
      return and();
    }
    
  }
  public class DnsNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNSFluentImpl<io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.DnsNested<N>> implements io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.DnsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DnsNestedImpl(io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNS item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNSBuilder(this, item);
    }
    DnsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNSBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNSBuilder builder;
    public N and() {
      return (N) StaticIPAMConfigFluentImpl.this.withDns(builder.build());
    }
    public N endDns() {
      return and();
    }
    
  }
  public class RoutesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesFluentImpl<io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoutesNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder(this, item);
    }
    RoutesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) StaticIPAMConfigFluentImpl.this.setToRoutes(index,builder.build());
    }
    public N endRoute() {
      return and();
    }
    
  }
  
}