package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface OpenShiftAPIServerFluent<A extends OpenShiftAPIServerFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public OpenShiftAPIServerFluent.MetadataNested<A> withNewMetadata();
    public OpenShiftAPIServerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public OpenShiftAPIServerFluent.MetadataNested<A> editMetadata();
    public OpenShiftAPIServerFluent.MetadataNested<A> editOrNewMetadata();
    public OpenShiftAPIServerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public OpenShiftAPIServerSpec getSpec();
    public OpenShiftAPIServerSpec buildSpec();
    public A withSpec(OpenShiftAPIServerSpec spec);
    public Boolean hasSpec();
    public OpenShiftAPIServerFluent.SpecNested<A> withNewSpec();
    public OpenShiftAPIServerFluent.SpecNested<A> withNewSpecLike(OpenShiftAPIServerSpec item);
    public OpenShiftAPIServerFluent.SpecNested<A> editSpec();
    public OpenShiftAPIServerFluent.SpecNested<A> editOrNewSpec();
    public OpenShiftAPIServerFluent.SpecNested<A> editOrNewSpecLike(OpenShiftAPIServerSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public OpenShiftAPIServerStatus getStatus();
    public OpenShiftAPIServerStatus buildStatus();
    public A withStatus(OpenShiftAPIServerStatus status);
    public Boolean hasStatus();
    public OpenShiftAPIServerFluent.StatusNested<A> withNewStatus();
    public OpenShiftAPIServerFluent.StatusNested<A> withNewStatusLike(OpenShiftAPIServerStatus item);
    public OpenShiftAPIServerFluent.StatusNested<A> editStatus();
    public OpenShiftAPIServerFluent.StatusNested<A> editOrNewStatus();
    public OpenShiftAPIServerFluent.StatusNested<A> editOrNewStatusLike(OpenShiftAPIServerStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<OpenShiftAPIServerFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftAPIServerSpecFluent<OpenShiftAPIServerFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftAPIServerStatusFluent<OpenShiftAPIServerFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
