package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkBuilder extends NetworkFluentImpl<NetworkBuilder> implements VisitableBuilder<Network,NetworkBuilder> {

    NetworkFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkBuilder() {
        this(true);
    }

    public NetworkBuilder(Boolean validationEnabled) {
        this(new Network(), validationEnabled);
    }

    public NetworkBuilder(NetworkFluent<?> fluent) {
        this(fluent, true);
    }

    public NetworkBuilder(NetworkFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Network(), validationEnabled);
    }

    public NetworkBuilder(NetworkFluent<?> fluent,Network instance) {
        this(fluent, instance, true);
    }

    public NetworkBuilder(NetworkFluent<?> fluent,Network instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public NetworkBuilder(Network instance) {
        this(instance,true);
    }

    public NetworkBuilder(Network instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public Network build() {
        Network buildable = new Network(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NetworkBuilder that = (NetworkBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
