package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LoggingDestinationBuilder extends LoggingDestinationFluentImpl<LoggingDestinationBuilder> implements VisitableBuilder<LoggingDestination,LoggingDestinationBuilder> {

    LoggingDestinationFluent<?> fluent;
    Boolean validationEnabled;

    public LoggingDestinationBuilder() {
        this(true);
    }

    public LoggingDestinationBuilder(Boolean validationEnabled) {
        this(new LoggingDestination(), validationEnabled);
    }

    public LoggingDestinationBuilder(LoggingDestinationFluent<?> fluent) {
        this(fluent, true);
    }

    public LoggingDestinationBuilder(LoggingDestinationFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new LoggingDestination(), validationEnabled);
    }

    public LoggingDestinationBuilder(LoggingDestinationFluent<?> fluent,LoggingDestination instance) {
        this(fluent, instance, true);
    }

    public LoggingDestinationBuilder(LoggingDestinationFluent<?> fluent,LoggingDestination instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withContainer(instance.getContainer()); 
        fluent.withSyslog(instance.getSyslog()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public LoggingDestinationBuilder(LoggingDestination instance) {
        this(instance,true);
    }

    public LoggingDestinationBuilder(LoggingDestination instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withContainer(instance.getContainer()); 
        this.withSyslog(instance.getSyslog()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public LoggingDestination build() {
        LoggingDestination buildable = new LoggingDestination(fluent.getContainer(),fluent.getSyslog(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LoggingDestinationBuilder that = (LoggingDestinationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
