package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleConfigRouteBuilder extends ConsoleConfigRouteFluentImpl<ConsoleConfigRouteBuilder> implements VisitableBuilder<ConsoleConfigRoute,ConsoleConfigRouteBuilder> {

    ConsoleConfigRouteFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleConfigRouteBuilder() {
        this(true);
    }

    public ConsoleConfigRouteBuilder(Boolean validationEnabled) {
        this(new ConsoleConfigRoute(), validationEnabled);
    }

    public ConsoleConfigRouteBuilder(ConsoleConfigRouteFluent<?> fluent) {
        this(fluent, true);
    }

    public ConsoleConfigRouteBuilder(ConsoleConfigRouteFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ConsoleConfigRoute(), validationEnabled);
    }

    public ConsoleConfigRouteBuilder(ConsoleConfigRouteFluent<?> fluent,ConsoleConfigRoute instance) {
        this(fluent, instance, true);
    }

    public ConsoleConfigRouteBuilder(ConsoleConfigRouteFluent<?> fluent,ConsoleConfigRoute instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHostname(instance.getHostname()); 
        fluent.withSecret(instance.getSecret()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleConfigRouteBuilder(ConsoleConfigRoute instance) {
        this(instance,true);
    }

    public ConsoleConfigRouteBuilder(ConsoleConfigRoute instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withHostname(instance.getHostname()); 
        this.withSecret(instance.getSecret()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleConfigRoute build() {
        ConsoleConfigRoute buildable = new ConsoleConfigRoute(fluent.getHostname(),fluent.getSecret());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleConfigRouteBuilder that = (ConsoleConfigRouteBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
