package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;

public interface KubeControllerManagerSpecFluent<A extends KubeControllerManagerSpecFluent<A>> extends Fluent<A> {


    public Integer getFailedRevisionLimit();
    public A withFailedRevisionLimit(Integer failedRevisionLimit);
    public Boolean hasFailedRevisionLimit();
    public String getForceRedeploymentReason();
    public A withForceRedeploymentReason(String forceRedeploymentReason);
    public Boolean hasForceRedeploymentReason();
    public A withNewForceRedeploymentReason(String arg1);
    public A withNewForceRedeploymentReason(StringBuilder arg1);
    public A withNewForceRedeploymentReason(StringBuffer arg1);
    public String getLogLevel();
    public A withLogLevel(String logLevel);
    public Boolean hasLogLevel();
    public A withNewLogLevel(String arg1);
    public A withNewLogLevel(StringBuilder arg1);
    public A withNewLogLevel(StringBuffer arg1);
    public String getManagementState();
    public A withManagementState(String managementState);
    public Boolean hasManagementState();
    public A withNewManagementState(String arg1);
    public A withNewManagementState(StringBuilder arg1);
    public A withNewManagementState(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildObservedConfig instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getObservedConfig();
    public HasMetadata buildObservedConfig();
    public A withObservedConfig(HasMetadata observedConfig);
    public Boolean hasObservedConfig();
    public A withImagePrunerObservedConfig(ImagePruner imagePrunerObservedConfig);
    public KubeControllerManagerSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfig();
    public KubeControllerManagerSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfigLike(ImagePruner item);
    public A withKubeControllerManagerObservedConfig(KubeControllerManager kubeControllerManagerObservedConfig);
    public KubeControllerManagerSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfig();
    public KubeControllerManagerSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfigLike(KubeControllerManager item);
    public A withImageContentSourcePolicyObservedConfig(ImageContentSourcePolicy imageContentSourcePolicyObservedConfig);
    public KubeControllerManagerSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfig();
    public KubeControllerManagerSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfigLike(ImageContentSourcePolicy item);
    public A withServiceCAObservedConfig(ServiceCA serviceCAObservedConfig);
    public KubeControllerManagerSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfig();
    public KubeControllerManagerSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfigLike(ServiceCA item);
    public A withPersistentVolumeClaimObservedConfig(PersistentVolumeClaim persistentVolumeClaimObservedConfig);
    public KubeControllerManagerSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfig();
    public KubeControllerManagerSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfigLike(PersistentVolumeClaim item);
    public A withKubeAPIServerObservedConfig(KubeAPIServer kubeAPIServerObservedConfig);
    public KubeControllerManagerSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfig();
    public KubeControllerManagerSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfigLike(KubeAPIServer item);
    public A withIngressControllerObservedConfig(IngressController ingressControllerObservedConfig);
    public KubeControllerManagerSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfig();
    public KubeControllerManagerSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfigLike(IngressController item);
    public A withKubeStorageVersionMigratorObservedConfig(KubeStorageVersionMigrator kubeStorageVersionMigratorObservedConfig);
    public KubeControllerManagerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfig();
    public KubeControllerManagerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfigLike(KubeStorageVersionMigrator item);
    public A withConsoleObservedConfig(Console consoleObservedConfig);
    public KubeControllerManagerSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfig();
    public KubeControllerManagerSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfigLike(Console item);
    public A withOpenShiftControllerManagerObservedConfig(OpenShiftControllerManager openShiftControllerManagerObservedConfig);
    public KubeControllerManagerSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfig();
    public KubeControllerManagerSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfigLike(OpenShiftControllerManager item);
    public A withEtcdObservedConfig(Etcd etcdObservedConfig);
    public KubeControllerManagerSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfig();
    public KubeControllerManagerSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfigLike(Etcd item);
    public A withKubeSchedulerObservedConfig(KubeScheduler kubeSchedulerObservedConfig);
    public KubeControllerManagerSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfig();
    public KubeControllerManagerSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfigLike(KubeScheduler item);
    public A withNetworkObservedConfig(Network networkObservedConfig);
    public KubeControllerManagerSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfig();
    public KubeControllerManagerSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfigLike(Network item);
    public A withServiceCatalogAPIServerObservedConfig(ServiceCatalogAPIServer serviceCatalogAPIServerObservedConfig);
    public KubeControllerManagerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfig();
    public KubeControllerManagerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfigLike(ServiceCatalogAPIServer item);
    public A withCSISnapshotControllerObservedConfig(CSISnapshotController cSISnapshotControllerObservedConfig);
    public KubeControllerManagerSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfig();
    public KubeControllerManagerSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfigLike(CSISnapshotController item);
    public A withServiceCatalogControllerManagerObservedConfig(ServiceCatalogControllerManager serviceCatalogControllerManagerObservedConfig);
    public KubeControllerManagerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfig();
    public KubeControllerManagerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfigLike(ServiceCatalogControllerManager item);
    public A withDNSObservedConfig(DNS dNSObservedConfig);
    public KubeControllerManagerSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfig();
    public KubeControllerManagerSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfigLike(DNS item);
    public A withDNSRecordObservedConfig(DNSRecord dNSRecordObservedConfig);
    public KubeControllerManagerSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfig();
    public KubeControllerManagerSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfigLike(DNSRecord item);
    public A withOpenShiftAPIServerObservedConfig(OpenShiftAPIServer openShiftAPIServerObservedConfig);
    public KubeControllerManagerSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfig();
    public KubeControllerManagerSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfigLike(OpenShiftAPIServer item);
    public A withAuthenticationObservedConfig(Authentication authenticationObservedConfig);
    public KubeControllerManagerSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfig();
    public KubeControllerManagerSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfigLike(Authentication item);
    public String getOperatorLogLevel();
    public A withOperatorLogLevel(String operatorLogLevel);
    public Boolean hasOperatorLogLevel();
    public A withNewOperatorLogLevel(String arg1);
    public A withNewOperatorLogLevel(StringBuilder arg1);
    public A withNewOperatorLogLevel(StringBuffer arg1);
    public Integer getSucceededRevisionLimit();
    public A withSucceededRevisionLimit(Integer succeededRevisionLimit);
    public Boolean hasSucceededRevisionLimit();
    
/**
 * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getUnsupportedConfigOverrides();
    public HasMetadata buildUnsupportedConfigOverrides();
    public A withUnsupportedConfigOverrides(HasMetadata unsupportedConfigOverrides);
    public Boolean hasUnsupportedConfigOverrides();
    public A withImagePrunerUnsupportedConfigOverrides(ImagePruner imagePrunerUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item);
    public A withKubeControllerManagerUnsupportedConfigOverrides(KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item);
    public A withImageContentSourcePolicyUnsupportedConfigOverrides(ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item);
    public A withServiceCAUnsupportedConfigOverrides(ServiceCA serviceCAUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item);
    public A withPersistentVolumeClaimUnsupportedConfigOverrides(PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item);
    public A withKubeAPIServerUnsupportedConfigOverrides(KubeAPIServer kubeAPIServerUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item);
    public A withIngressControllerUnsupportedConfigOverrides(IngressController ingressControllerUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item);
    public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item);
    public A withConsoleUnsupportedConfigOverrides(Console consoleUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item);
    public A withOpenShiftControllerManagerUnsupportedConfigOverrides(OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item);
    public A withEtcdUnsupportedConfigOverrides(Etcd etcdUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item);
    public A withKubeSchedulerUnsupportedConfigOverrides(KubeScheduler kubeSchedulerUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item);
    public A withNetworkUnsupportedConfigOverrides(Network networkUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item);
    public A withServiceCatalogAPIServerUnsupportedConfigOverrides(ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item);
    public A withCSISnapshotControllerUnsupportedConfigOverrides(CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item);
    public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item);
    public A withDNSUnsupportedConfigOverrides(DNS dNSUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item);
    public A withDNSRecordUnsupportedConfigOverrides(DNSRecord dNSRecordUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item);
    public A withOpenShiftAPIServerUnsupportedConfigOverrides(OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item);
    public A withAuthenticationUnsupportedConfigOverrides(Authentication authenticationUnsupportedConfigOverrides);
    public KubeControllerManagerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides();
    public KubeControllerManagerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item);
    public interface ImagePrunerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImagePrunerFluent<KubeControllerManagerSpecFluent.ImagePrunerObservedConfigNested<N>> {

            public N and();
            public N endImagePrunerObservedConfig();    }


    public interface KubeControllerManagerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeControllerManagerFluent<KubeControllerManagerSpecFluent.KubeControllerManagerObservedConfigNested<N>> {

            public N and();
            public N endKubeControllerManagerObservedConfig();    }


    public interface ImageContentSourcePolicyObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageContentSourcePolicyFluent<KubeControllerManagerSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>> {

            public N and();
            public N endImageContentSourcePolicyObservedConfig();    }


    public interface ServiceCAObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCAFluent<KubeControllerManagerSpecFluent.ServiceCAObservedConfigNested<N>> {

            public N and();
            public N endServiceCAObservedConfig();    }


    public interface PersistentVolumeClaimObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<KubeControllerManagerSpecFluent.PersistentVolumeClaimObservedConfigNested<N>> {

            public N and();
            public N endPersistentVolumeClaimObservedConfig();    }


    public interface KubeAPIServerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeAPIServerFluent<KubeControllerManagerSpecFluent.KubeAPIServerObservedConfigNested<N>> {

            public N and();
            public N endKubeAPIServerObservedConfig();    }


    public interface IngressControllerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressControllerFluent<KubeControllerManagerSpecFluent.IngressControllerObservedConfigNested<N>> {

            public N and();
            public N endIngressControllerObservedConfig();    }


    public interface KubeStorageVersionMigratorObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeStorageVersionMigratorFluent<KubeControllerManagerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>> {

            public N and();
            public N endKubeStorageVersionMigratorObservedConfig();    }


    public interface ConsoleObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleFluent<KubeControllerManagerSpecFluent.ConsoleObservedConfigNested<N>> {

            public N and();
            public N endConsoleObservedConfig();    }


    public interface OpenShiftControllerManagerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftControllerManagerFluent<KubeControllerManagerSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>> {

            public N and();
            public N endOpenShiftControllerManagerObservedConfig();    }


    public interface EtcdObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EtcdFluent<KubeControllerManagerSpecFluent.EtcdObservedConfigNested<N>> {

            public N and();
            public N endEtcdObservedConfig();    }


    public interface KubeSchedulerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeSchedulerFluent<KubeControllerManagerSpecFluent.KubeSchedulerObservedConfigNested<N>> {

            public N and();
            public N endKubeSchedulerObservedConfig();    }


    public interface NetworkObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkFluent<KubeControllerManagerSpecFluent.NetworkObservedConfigNested<N>> {

            public N and();
            public N endNetworkObservedConfig();    }


    public interface ServiceCatalogAPIServerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogAPIServerFluent<KubeControllerManagerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>> {

            public N and();
            public N endServiceCatalogAPIServerObservedConfig();    }


    public interface CSISnapshotControllerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CSISnapshotControllerFluent<KubeControllerManagerSpecFluent.CSISnapshotControllerObservedConfigNested<N>> {

            public N and();
            public N endCSISnapshotControllerObservedConfig();    }


    public interface ServiceCatalogControllerManagerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogControllerManagerFluent<KubeControllerManagerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>> {

            public N and();
            public N endServiceCatalogControllerManagerObservedConfig();    }


    public interface DNSObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSFluent<KubeControllerManagerSpecFluent.DNSObservedConfigNested<N>> {

            public N and();
            public N endDNSObservedConfig();    }


    public interface DNSRecordObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSRecordFluent<KubeControllerManagerSpecFluent.DNSRecordObservedConfigNested<N>> {

            public N and();
            public N endDNSRecordObservedConfig();    }


    public interface OpenShiftAPIServerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftAPIServerFluent<KubeControllerManagerSpecFluent.OpenShiftAPIServerObservedConfigNested<N>> {

            public N and();
            public N endOpenShiftAPIServerObservedConfig();    }


    public interface AuthenticationObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AuthenticationFluent<KubeControllerManagerSpecFluent.AuthenticationObservedConfigNested<N>> {

            public N and();
            public N endAuthenticationObservedConfig();    }


    public interface ImagePrunerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImagePrunerFluent<KubeControllerManagerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endImagePrunerUnsupportedConfigOverrides();    }


    public interface KubeControllerManagerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeControllerManagerFluent<KubeControllerManagerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endKubeControllerManagerUnsupportedConfigOverrides();    }


    public interface ImageContentSourcePolicyUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageContentSourcePolicyFluent<KubeControllerManagerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endImageContentSourcePolicyUnsupportedConfigOverrides();    }


    public interface ServiceCAUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCAFluent<KubeControllerManagerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endServiceCAUnsupportedConfigOverrides();    }


    public interface PersistentVolumeClaimUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<KubeControllerManagerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endPersistentVolumeClaimUnsupportedConfigOverrides();    }


    public interface KubeAPIServerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeAPIServerFluent<KubeControllerManagerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endKubeAPIServerUnsupportedConfigOverrides();    }


    public interface IngressControllerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressControllerFluent<KubeControllerManagerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endIngressControllerUnsupportedConfigOverrides();    }


    public interface KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeStorageVersionMigratorFluent<KubeControllerManagerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endKubeStorageVersionMigratorUnsupportedConfigOverrides();    }


    public interface ConsoleUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleFluent<KubeControllerManagerSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endConsoleUnsupportedConfigOverrides();    }


    public interface OpenShiftControllerManagerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftControllerManagerFluent<KubeControllerManagerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endOpenShiftControllerManagerUnsupportedConfigOverrides();    }


    public interface EtcdUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EtcdFluent<KubeControllerManagerSpecFluent.EtcdUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endEtcdUnsupportedConfigOverrides();    }


    public interface KubeSchedulerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeSchedulerFluent<KubeControllerManagerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endKubeSchedulerUnsupportedConfigOverrides();    }


    public interface NetworkUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkFluent<KubeControllerManagerSpecFluent.NetworkUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endNetworkUnsupportedConfigOverrides();    }


    public interface ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogAPIServerFluent<KubeControllerManagerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endServiceCatalogAPIServerUnsupportedConfigOverrides();    }


    public interface CSISnapshotControllerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CSISnapshotControllerFluent<KubeControllerManagerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endCSISnapshotControllerUnsupportedConfigOverrides();    }


    public interface ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogControllerManagerFluent<KubeControllerManagerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endServiceCatalogControllerManagerUnsupportedConfigOverrides();    }


    public interface DNSUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSFluent<KubeControllerManagerSpecFluent.DNSUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endDNSUnsupportedConfigOverrides();    }


    public interface DNSRecordUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSRecordFluent<KubeControllerManagerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endDNSRecordUnsupportedConfigOverrides();    }


    public interface OpenShiftAPIServerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftAPIServerFluent<KubeControllerManagerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endOpenShiftAPIServerUnsupportedConfigOverrides();    }


    public interface AuthenticationUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AuthenticationFluent<KubeControllerManagerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endAuthenticationUnsupportedConfigOverrides();    }


}
