package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImagePrunerListBuilder extends ImagePrunerListFluentImpl<ImagePrunerListBuilder> implements VisitableBuilder<ImagePrunerList,ImagePrunerListBuilder> {

    ImagePrunerListFluent<?> fluent;
    Boolean validationEnabled;

    public ImagePrunerListBuilder() {
        this(true);
    }

    public ImagePrunerListBuilder(Boolean validationEnabled) {
        this(new ImagePrunerList(), validationEnabled);
    }

    public ImagePrunerListBuilder(ImagePrunerListFluent<?> fluent) {
        this(fluent, true);
    }

    public ImagePrunerListBuilder(ImagePrunerListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ImagePrunerList(), validationEnabled);
    }

    public ImagePrunerListBuilder(ImagePrunerListFluent<?> fluent,ImagePrunerList instance) {
        this(fluent, instance, true);
    }

    public ImagePrunerListBuilder(ImagePrunerListFluent<?> fluent,ImagePrunerList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImagePrunerListBuilder(ImagePrunerList instance) {
        this(instance,true);
    }

    public ImagePrunerListBuilder(ImagePrunerList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImagePrunerList build() {
        ImagePrunerList buildable = new ImagePrunerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ImagePrunerListBuilder that = (ImagePrunerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
