package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AuthenticationListBuilder extends AuthenticationListFluentImpl<AuthenticationListBuilder> implements VisitableBuilder<AuthenticationList,AuthenticationListBuilder> {

    AuthenticationListFluent<?> fluent;
    Boolean validationEnabled;

    public AuthenticationListBuilder() {
        this(true);
    }

    public AuthenticationListBuilder(Boolean validationEnabled) {
        this(new AuthenticationList(), validationEnabled);
    }

    public AuthenticationListBuilder(AuthenticationListFluent<?> fluent) {
        this(fluent, true);
    }

    public AuthenticationListBuilder(AuthenticationListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AuthenticationList(), validationEnabled);
    }

    public AuthenticationListBuilder(AuthenticationListFluent<?> fluent,AuthenticationList instance) {
        this(fluent, instance, true);
    }

    public AuthenticationListBuilder(AuthenticationListFluent<?> fluent,AuthenticationList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public AuthenticationListBuilder(AuthenticationList instance) {
        this(instance,true);
    }

    public AuthenticationListBuilder(AuthenticationList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public AuthenticationList build() {
        AuthenticationList buildable = new AuthenticationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AuthenticationListBuilder that = (AuthenticationListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
