package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface IngressControllerListFluent<A extends IngressControllerListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,IngressController item);
    public A setToItems(int index,IngressController item);
    public A addToItems(IngressController... items);
    public A addAllToItems(Collection<IngressController> items);
    public A removeFromItems(IngressController... items);
    public A removeAllFromItems(Collection<IngressController> items);
    public A removeMatchingFromItems(Predicate<IngressControllerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<IngressController> getItems();
    public List<IngressController> buildItems();
    public IngressController buildItem(int index);
    public IngressController buildFirstItem();
    public IngressController buildLastItem();
    public IngressController buildMatchingItem(Predicate<IngressControllerBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<IngressControllerBuilder> predicate);
    public A withItems(List<IngressController> items);
    public A withItems(IngressController... items);
    public Boolean hasItems();
    public IngressControllerListFluent.ItemsNested<A> addNewItem();
    public IngressControllerListFluent.ItemsNested<A> addNewItemLike(IngressController item);
    public IngressControllerListFluent.ItemsNested<A> setNewItemLike(int index,IngressController item);
    public IngressControllerListFluent.ItemsNested<A> editItem(int index);
    public IngressControllerListFluent.ItemsNested<A> editFirstItem();
    public IngressControllerListFluent.ItemsNested<A> editLastItem();
    public IngressControllerListFluent.ItemsNested<A> editMatchingItem(Predicate<IngressControllerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressControllerFluent<IngressControllerListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
