package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressControllerCaptureHTTPCookieBuilder extends IngressControllerCaptureHTTPCookieFluentImpl<IngressControllerCaptureHTTPCookieBuilder> implements VisitableBuilder<IngressControllerCaptureHTTPCookie,IngressControllerCaptureHTTPCookieBuilder> {

    IngressControllerCaptureHTTPCookieFluent<?> fluent;
    Boolean validationEnabled;

    public IngressControllerCaptureHTTPCookieBuilder() {
        this(true);
    }

    public IngressControllerCaptureHTTPCookieBuilder(Boolean validationEnabled) {
        this(new IngressControllerCaptureHTTPCookie(), validationEnabled);
    }

    public IngressControllerCaptureHTTPCookieBuilder(IngressControllerCaptureHTTPCookieFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressControllerCaptureHTTPCookieBuilder(IngressControllerCaptureHTTPCookieFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IngressControllerCaptureHTTPCookie(), validationEnabled);
    }

    public IngressControllerCaptureHTTPCookieBuilder(IngressControllerCaptureHTTPCookieFluent<?> fluent,IngressControllerCaptureHTTPCookie instance) {
        this(fluent, instance, true);
    }

    public IngressControllerCaptureHTTPCookieBuilder(IngressControllerCaptureHTTPCookieFluent<?> fluent,IngressControllerCaptureHTTPCookie instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMatchType(instance.getMatchType()); 
        fluent.withMaxLength(instance.getMaxLength()); 
        fluent.withName(instance.getName()); 
        fluent.withNamePrefix(instance.getNamePrefix()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressControllerCaptureHTTPCookieBuilder(IngressControllerCaptureHTTPCookie instance) {
        this(instance,true);
    }

    public IngressControllerCaptureHTTPCookieBuilder(IngressControllerCaptureHTTPCookie instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withMatchType(instance.getMatchType()); 
        this.withMaxLength(instance.getMaxLength()); 
        this.withName(instance.getName()); 
        this.withNamePrefix(instance.getNamePrefix()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressControllerCaptureHTTPCookie build() {
        IngressControllerCaptureHTTPCookie buildable = new IngressControllerCaptureHTTPCookie(fluent.getMatchType(),fluent.getMaxLength(),fluent.getName(),fluent.getNamePrefix());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressControllerCaptureHTTPCookieBuilder that = (IngressControllerCaptureHTTPCookieBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
