package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ImagePrunerSpecFluent<A extends ImagePrunerSpecFluent<A>> extends Fluent<A> {


    public Affinity getAffinity();
    public A withAffinity(Affinity affinity);
    public Boolean hasAffinity();
    public Integer getFailedJobsHistoryLimit();
    public A withFailedJobsHistoryLimit(Integer failedJobsHistoryLimit);
    public Boolean hasFailedJobsHistoryLimit();
    public Boolean isIgnoreInvalidImageReferences();
    public A withIgnoreInvalidImageReferences(Boolean ignoreInvalidImageReferences);
    public Boolean hasIgnoreInvalidImageReferences();
    public A withNewIgnoreInvalidImageReferences(String arg1);
    public A withNewIgnoreInvalidImageReferences(boolean arg1);
    public Integer getKeepTagRevisions();
    public A withKeepTagRevisions(Integer keepTagRevisions);
    public Boolean hasKeepTagRevisions();
    public Long getKeepYoungerThan();
    public A withKeepYoungerThan(Long keepYoungerThan);
    public Boolean hasKeepYoungerThan();
    public Duration getKeepYoungerThanDuration();
    public A withKeepYoungerThanDuration(Duration keepYoungerThanDuration);
    public Boolean hasKeepYoungerThanDuration();
    public A addToNodeSelector(String key,String value);
    public A addToNodeSelector(Map<String,String> map);
    public A removeFromNodeSelector(String key);
    public A removeFromNodeSelector(Map<String,String> map);
    public Map<String,String> getNodeSelector();
    public A withNodeSelector(Map<String,String> nodeSelector);
    public Boolean hasNodeSelector();
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public ResourceRequirements getResources();
    public ResourceRequirements buildResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    public ImagePrunerSpecFluent.ResourcesNested<A> withNewResources();
    public ImagePrunerSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
    public ImagePrunerSpecFluent.ResourcesNested<A> editResources();
    public ImagePrunerSpecFluent.ResourcesNested<A> editOrNewResources();
    public ImagePrunerSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
    public String getSchedule();
    public A withSchedule(String schedule);
    public Boolean hasSchedule();
    public A withNewSchedule(String arg1);
    public A withNewSchedule(StringBuilder arg1);
    public A withNewSchedule(StringBuffer arg1);
    public Integer getSuccessfulJobsHistoryLimit();
    public A withSuccessfulJobsHistoryLimit(Integer successfulJobsHistoryLimit);
    public Boolean hasSuccessfulJobsHistoryLimit();
    public Boolean isSuspend();
    public A withSuspend(Boolean suspend);
    public Boolean hasSuspend();
    public A withNewSuspend(String arg1);
    public A withNewSuspend(boolean arg1);
    public A addToTolerations(int index,Toleration item);
    public A setToTolerations(int index,Toleration item);
    public A addToTolerations(Toleration... items);
    public A addAllToTolerations(Collection<Toleration> items);
    public A removeFromTolerations(Toleration... items);
    public A removeAllFromTolerations(Collection<Toleration> items);
    public List<Toleration> getTolerations();
    public Toleration getToleration(int index);
    public Toleration getFirstToleration();
    public Toleration getLastToleration();
    public Toleration getMatchingToleration(Predicate<Toleration> predicate);
    public Boolean hasMatchingToleration(Predicate<Toleration> predicate);
    public A withTolerations(List<Toleration> tolerations);
    public A withTolerations(Toleration... tolerations);
    public Boolean hasTolerations();
    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value);
    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceRequirementsFluent<ImagePrunerSpecFluent.ResourcesNested<N>> {

            public N and();
            public N endResources();    }


}
