package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OldTLSProfileBuilder extends OldTLSProfileFluentImpl<OldTLSProfileBuilder> implements VisitableBuilder<OldTLSProfile,OldTLSProfileBuilder> {

    OldTLSProfileFluent<?> fluent;
    Boolean validationEnabled;

    public OldTLSProfileBuilder() {
        this(true);
    }

    public OldTLSProfileBuilder(Boolean validationEnabled) {
        this(new OldTLSProfile(), validationEnabled);
    }

    public OldTLSProfileBuilder(OldTLSProfileFluent<?> fluent) {
        this(fluent, true);
    }

    public OldTLSProfileBuilder(OldTLSProfileFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new OldTLSProfile(), validationEnabled);
    }

    public OldTLSProfileBuilder(OldTLSProfileFluent<?> fluent,OldTLSProfile instance) {
        this(fluent, instance, true);
    }

    public OldTLSProfileBuilder(OldTLSProfileFluent<?> fluent,OldTLSProfile instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public OldTLSProfileBuilder(OldTLSProfile instance) {
        this(instance,true);
    }

    public OldTLSProfileBuilder(OldTLSProfile instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public OldTLSProfile build() {
        OldTLSProfile buildable = new OldTLSProfile();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OldTLSProfileBuilder that = (OldTLSProfileBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
