package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ServiceCatalogAPIServerFluent<A extends ServiceCatalogAPIServerFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ServiceCatalogAPIServerFluent.MetadataNested<A> withNewMetadata();
    public ServiceCatalogAPIServerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ServiceCatalogAPIServerFluent.MetadataNested<A> editMetadata();
    public ServiceCatalogAPIServerFluent.MetadataNested<A> editOrNewMetadata();
    public ServiceCatalogAPIServerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ServiceCatalogAPIServerSpec getSpec();
    public ServiceCatalogAPIServerSpec buildSpec();
    public A withSpec(ServiceCatalogAPIServerSpec spec);
    public Boolean hasSpec();
    public ServiceCatalogAPIServerFluent.SpecNested<A> withNewSpec();
    public ServiceCatalogAPIServerFluent.SpecNested<A> withNewSpecLike(ServiceCatalogAPIServerSpec item);
    public ServiceCatalogAPIServerFluent.SpecNested<A> editSpec();
    public ServiceCatalogAPIServerFluent.SpecNested<A> editOrNewSpec();
    public ServiceCatalogAPIServerFluent.SpecNested<A> editOrNewSpecLike(ServiceCatalogAPIServerSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public ServiceCatalogAPIServerStatus getStatus();
    public ServiceCatalogAPIServerStatus buildStatus();
    public A withStatus(ServiceCatalogAPIServerStatus status);
    public Boolean hasStatus();
    public ServiceCatalogAPIServerFluent.StatusNested<A> withNewStatus();
    public ServiceCatalogAPIServerFluent.StatusNested<A> withNewStatusLike(ServiceCatalogAPIServerStatus item);
    public ServiceCatalogAPIServerFluent.StatusNested<A> editStatus();
    public ServiceCatalogAPIServerFluent.StatusNested<A> editOrNewStatus();
    public ServiceCatalogAPIServerFluent.StatusNested<A> editOrNewStatusLike(ServiceCatalogAPIServerStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ServiceCatalogAPIServerFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogAPIServerSpecFluent<ServiceCatalogAPIServerFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogAPIServerStatusFluent<ServiceCatalogAPIServerFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
