package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class DNSRecordStatusFluentImpl<A extends DNSRecordStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DNSRecordStatusFluent<A> {

    private Long observedGeneration;
    private List<DNSZoneStatusBuilder> zones =  new ArrayList<DNSZoneStatusBuilder>();

    public DNSRecordStatusFluentImpl() {
    }

    public DNSRecordStatusFluentImpl(DNSRecordStatus instance) {
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withZones(instance.getZones()); 
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToZones(int index,DNSZoneStatus item) {
        if (this.zones == null) {this.zones = new ArrayList<DNSZoneStatusBuilder>();}
        DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);_visitables.get("zones").add(index >= 0 ? index : _visitables.get("zones").size(), builder);this.zones.add(index >= 0 ? index : zones.size(), builder); return (A)this;
    }

    public A setToZones(int index,DNSZoneStatus item) {
        if (this.zones == null) {this.zones = new ArrayList<DNSZoneStatusBuilder>();}
        DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);
        if (index < 0 || index >= _visitables.get("zones").size()) { _visitables.get("zones").add(builder); } else { _visitables.get("zones").set(index, builder);}
        if (index < 0 || index >= zones.size()) { zones.add(builder); } else { zones.set(index, builder);}
         return (A)this;
    }

    public A addToZones(DNSZoneStatus... items) {
        if (this.zones == null) {this.zones = new ArrayList<DNSZoneStatusBuilder>();}
        for (DNSZoneStatus item : items) {DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);_visitables.get("zones").add(builder);this.zones.add(builder);} return (A)this;
    }

    public A addAllToZones(Collection<DNSZoneStatus> items) {
        if (this.zones == null) {this.zones = new ArrayList<DNSZoneStatusBuilder>();}
        for (DNSZoneStatus item : items) {DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);_visitables.get("zones").add(builder);this.zones.add(builder);} return (A)this;
    }

    public A removeFromZones(DNSZoneStatus... items) {
        for (DNSZoneStatus item : items) {DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);_visitables.get("zones").remove(builder);if (this.zones != null) {this.zones.remove(builder);}} return (A)this;
    }

    public A removeAllFromZones(Collection<DNSZoneStatus> items) {
        for (DNSZoneStatus item : items) {DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);_visitables.get("zones").remove(builder);if (this.zones != null) {this.zones.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromZones(Predicate<DNSZoneStatusBuilder> predicate) {
        if (zones == null) return (A) this;
        final Iterator<DNSZoneStatusBuilder> each = zones.iterator();
        final List visitables = _visitables.get("zones");
        while (each.hasNext()) {
          DNSZoneStatusBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildZones instead.
 * @return The buildable object.
 */
@Deprecated public List<DNSZoneStatus> getZones() {
        return build(zones);
    }

    public List<DNSZoneStatus> buildZones() {
        return build(zones);
    }

    public DNSZoneStatus buildZone(int index) {
        return this.zones.get(index).build();
    }

    public DNSZoneStatus buildFirstZone() {
        return this.zones.get(0).build();
    }

    public DNSZoneStatus buildLastZone() {
        return this.zones.get(zones.size() - 1).build();
    }

    public DNSZoneStatus buildMatchingZone(Predicate<DNSZoneStatusBuilder> predicate) {
        for (DNSZoneStatusBuilder item: zones) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingZone(Predicate<DNSZoneStatusBuilder> predicate) {
        for (DNSZoneStatusBuilder item: zones) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withZones(List<DNSZoneStatus> zones) {
        if (this.zones != null) { _visitables.get("zones").removeAll(this.zones);}
        if (zones != null) {this.zones = new ArrayList<DNSZoneStatusBuilder>(); for (DNSZoneStatus item : zones){this.addToZones(item);}} else { this.zones = null;} return (A) this;
    }

    public A withZones(DNSZoneStatus... zones) {
        if (this.zones != null) {this.zones.clear();}
        if (zones != null) {for (DNSZoneStatus item :zones){ this.addToZones(item);}} return (A) this;
    }

    public Boolean hasZones() {
        return zones != null && !zones.isEmpty();
    }

    public DNSRecordStatusFluent.ZonesNested<A> addNewZone() {
        return new ZonesNestedImpl();
    }

    public DNSRecordStatusFluent.ZonesNested<A> addNewZoneLike(DNSZoneStatus item) {
        return new ZonesNestedImpl(-1, item);
    }

    public DNSRecordStatusFluent.ZonesNested<A> setNewZoneLike(int index,DNSZoneStatus item) {
        return new ZonesNestedImpl(index, item);
    }

    public DNSRecordStatusFluent.ZonesNested<A> editZone(int index) {
        if (zones.size() <= index) throw new RuntimeException("Can't edit zones. Index exceeds size.");
        return setNewZoneLike(index, buildZone(index));
    }

    public DNSRecordStatusFluent.ZonesNested<A> editFirstZone() {
        if (zones.size() == 0) throw new RuntimeException("Can't edit first zones. The list is empty.");
        return setNewZoneLike(0, buildZone(0));
    }

    public DNSRecordStatusFluent.ZonesNested<A> editLastZone() {
        int index = zones.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last zones. The list is empty.");
        return setNewZoneLike(index, buildZone(index));
    }

    public DNSRecordStatusFluent.ZonesNested<A> editMatchingZone(Predicate<DNSZoneStatusBuilder> predicate) {
        int index = -1;
        for (int i=0;i<zones.size();i++) { 
        if (predicate.test(zones.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching zones. No match found.");
        return setNewZoneLike(index, buildZone(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DNSRecordStatusFluentImpl that = (DNSRecordStatusFluentImpl) o;
        if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
        if (zones != null ? !zones.equals(that.zones) :that.zones != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(observedGeneration,  zones,  super.hashCode());
    }

    public class ZonesNestedImpl<N> extends DNSZoneStatusFluentImpl<DNSRecordStatusFluent.ZonesNested<N>> implements DNSRecordStatusFluent.ZonesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DNSZoneStatusBuilder builder;
        private final int index;

            ZonesNestedImpl(int index,DNSZoneStatus item) {
                this.index = index;
                this.builder = new DNSZoneStatusBuilder(this, item);
                        
            }

            ZonesNestedImpl() {
                this.index = -1;
                this.builder = new DNSZoneStatusBuilder(this);
                        
            }

            public N and() {
                return (N) DNSRecordStatusFluentImpl.this.setToZones(index,builder.build());
            }

            public N endZone() {
                return and();
            }
    }


}
