package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import io.fabric8.openshift.api.model.ConfigMapFileReferenceFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.openshift.api.model.ConfigMapFileReference;

public interface ConsoleCustomizationFluent<A extends ConsoleCustomizationFluent<A>> extends Fluent<A> {


    public String getBrand();
    public A withBrand(String brand);
    public Boolean hasBrand();
    public A withNewBrand(String arg1);
    public A withNewBrand(StringBuilder arg1);
    public A withNewBrand(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildCustomLogoFile instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapFileReference getCustomLogoFile();
    public ConfigMapFileReference buildCustomLogoFile();
    public A withCustomLogoFile(ConfigMapFileReference customLogoFile);
    public Boolean hasCustomLogoFile();
    public A withNewCustomLogoFile(String key,String name);
    public ConsoleCustomizationFluent.CustomLogoFileNested<A> withNewCustomLogoFile();
    public ConsoleCustomizationFluent.CustomLogoFileNested<A> withNewCustomLogoFileLike(ConfigMapFileReference item);
    public ConsoleCustomizationFluent.CustomLogoFileNested<A> editCustomLogoFile();
    public ConsoleCustomizationFluent.CustomLogoFileNested<A> editOrNewCustomLogoFile();
    public ConsoleCustomizationFluent.CustomLogoFileNested<A> editOrNewCustomLogoFileLike(ConfigMapFileReference item);
    public String getCustomProductName();
    public A withCustomProductName(String customProductName);
    public Boolean hasCustomProductName();
    public A withNewCustomProductName(String arg1);
    public A withNewCustomProductName(StringBuilder arg1);
    public A withNewCustomProductName(StringBuffer arg1);
    public String getDocumentationBaseURL();
    public A withDocumentationBaseURL(String documentationBaseURL);
    public Boolean hasDocumentationBaseURL();
    public A withNewDocumentationBaseURL(String arg1);
    public A withNewDocumentationBaseURL(StringBuilder arg1);
    public A withNewDocumentationBaseURL(StringBuffer arg1);
    public interface CustomLogoFileNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConfigMapFileReferenceFluent<ConsoleCustomizationFluent.CustomLogoFileNested<N>> {

            public N and();
            public N endCustomLogoFile();    }


}
