package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeStorageVersionMigratorListBuilder extends KubeStorageVersionMigratorListFluentImpl<KubeStorageVersionMigratorListBuilder> implements VisitableBuilder<KubeStorageVersionMigratorList,KubeStorageVersionMigratorListBuilder> {

    KubeStorageVersionMigratorListFluent<?> fluent;
    Boolean validationEnabled;

    public KubeStorageVersionMigratorListBuilder() {
        this(true);
    }

    public KubeStorageVersionMigratorListBuilder(Boolean validationEnabled) {
        this(new KubeStorageVersionMigratorList(), validationEnabled);
    }

    public KubeStorageVersionMigratorListBuilder(KubeStorageVersionMigratorListFluent<?> fluent) {
        this(fluent, true);
    }

    public KubeStorageVersionMigratorListBuilder(KubeStorageVersionMigratorListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KubeStorageVersionMigratorList(), validationEnabled);
    }

    public KubeStorageVersionMigratorListBuilder(KubeStorageVersionMigratorListFluent<?> fluent,KubeStorageVersionMigratorList instance) {
        this(fluent, instance, true);
    }

    public KubeStorageVersionMigratorListBuilder(KubeStorageVersionMigratorListFluent<?> fluent,KubeStorageVersionMigratorList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubeStorageVersionMigratorListBuilder(KubeStorageVersionMigratorList instance) {
        this(instance,true);
    }

    public KubeStorageVersionMigratorListBuilder(KubeStorageVersionMigratorList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubeStorageVersionMigratorList build() {
        KubeStorageVersionMigratorList buildable = new KubeStorageVersionMigratorList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KubeStorageVersionMigratorListBuilder that = (KubeStorageVersionMigratorListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
