package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ImagePrunerListFluent<A extends ImagePrunerListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ImagePruner item);
    public A setToItems(int index,ImagePruner item);
    public A addToItems(ImagePruner... items);
    public A addAllToItems(Collection<ImagePruner> items);
    public A removeFromItems(ImagePruner... items);
    public A removeAllFromItems(Collection<ImagePruner> items);
    public A removeMatchingFromItems(Predicate<ImagePrunerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ImagePruner> getItems();
    public List<ImagePruner> buildItems();
    public ImagePruner buildItem(int index);
    public ImagePruner buildFirstItem();
    public ImagePruner buildLastItem();
    public ImagePruner buildMatchingItem(Predicate<ImagePrunerBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ImagePrunerBuilder> predicate);
    public A withItems(List<ImagePruner> items);
    public A withItems(ImagePruner... items);
    public Boolean hasItems();
    public ImagePrunerListFluent.ItemsNested<A> addNewItem();
    public ImagePrunerListFluent.ItemsNested<A> addNewItemLike(ImagePruner item);
    public ImagePrunerListFluent.ItemsNested<A> setNewItemLike(int index,ImagePruner item);
    public ImagePrunerListFluent.ItemsNested<A> editItem(int index);
    public ImagePrunerListFluent.ItemsNested<A> editFirstItem();
    public ImagePrunerListFluent.ItemsNested<A> editLastItem();
    public ImagePrunerListFluent.ItemsNested<A> editMatchingItem(Predicate<ImagePrunerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImagePrunerFluent<ImagePrunerListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
