package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EtcdBuilder extends EtcdFluentImpl<EtcdBuilder> implements VisitableBuilder<Etcd,EtcdBuilder> {

    EtcdFluent<?> fluent;
    Boolean validationEnabled;

    public EtcdBuilder() {
        this(true);
    }

    public EtcdBuilder(Boolean validationEnabled) {
        this(new Etcd(), validationEnabled);
    }

    public EtcdBuilder(EtcdFluent<?> fluent) {
        this(fluent, true);
    }

    public EtcdBuilder(EtcdFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Etcd(), validationEnabled);
    }

    public EtcdBuilder(EtcdFluent<?> fluent,Etcd instance) {
        this(fluent, instance, true);
    }

    public EtcdBuilder(EtcdFluent<?> fluent,Etcd instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public EtcdBuilder(Etcd instance) {
        this(instance,true);
    }

    public EtcdBuilder(Etcd instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public Etcd build() {
        Etcd buildable = new Etcd(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EtcdBuilder that = (EtcdBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
