package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class TLSProfileSpecFluentImpl<A extends TLSProfileSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TLSProfileSpecFluent<A> {

    private List<String> ciphers = new ArrayList<String>();
    private String minTLSVersion;

    public TLSProfileSpecFluentImpl() {
    }

    public TLSProfileSpecFluentImpl(TLSProfileSpec instance) {
        this.withCiphers(instance.getCiphers()); 
        this.withMinTLSVersion(instance.getMinTLSVersion()); 
    }

    public A addToCiphers(int index,String item) {
        if (this.ciphers == null) {this.ciphers = new ArrayList<String>();}
        this.ciphers.add(index, item);
        return (A)this;
    }

    public A setToCiphers(int index,String item) {
        if (this.ciphers == null) {this.ciphers = new ArrayList<String>();}
        this.ciphers.set(index, item); return (A)this;
    }

    public A addToCiphers(String... items) {
        if (this.ciphers == null) {this.ciphers = new ArrayList<String>();}
        for (String item : items) {this.ciphers.add(item);} return (A)this;
    }

    public A addAllToCiphers(Collection<String> items) {
        if (this.ciphers == null) {this.ciphers = new ArrayList<String>();}
        for (String item : items) {this.ciphers.add(item);} return (A)this;
    }

    public A removeFromCiphers(String... items) {
        for (String item : items) {if (this.ciphers!= null){ this.ciphers.remove(item);}} return (A)this;
    }

    public A removeAllFromCiphers(Collection<String> items) {
        for (String item : items) {if (this.ciphers!= null){ this.ciphers.remove(item);}} return (A)this;
    }

    public List<String> getCiphers() {
        return this.ciphers;
    }

    public String getCipher(int index) {
        return this.ciphers.get(index);
    }

    public String getFirstCipher() {
        return this.ciphers.get(0);
    }

    public String getLastCipher() {
        return this.ciphers.get(ciphers.size() - 1);
    }

    public String getMatchingCipher(Predicate<String> predicate) {
        for (String item: ciphers) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingCipher(Predicate<String> predicate) {
        for (String item: ciphers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withCiphers(List<String> ciphers) {
        if (this.ciphers != null) { _visitables.get("ciphers").removeAll(this.ciphers);}
        if (ciphers != null) {this.ciphers = new ArrayList<String>(); for (String item : ciphers){this.addToCiphers(item);}} else { this.ciphers = null;} return (A) this;
    }

    public A withCiphers(String... ciphers) {
        if (this.ciphers != null) {this.ciphers.clear();}
        if (ciphers != null) {for (String item :ciphers){ this.addToCiphers(item);}} return (A) this;
    }

    public Boolean hasCiphers() {
        return ciphers != null && !ciphers.isEmpty();
    }

    public A addNewCipher(String arg1) {
        return (A)addToCiphers(new String(arg1));
    }

    public A addNewCipher(StringBuilder arg1) {
        return (A)addToCiphers(new String(arg1));
    }

    public A addNewCipher(StringBuffer arg1) {
        return (A)addToCiphers(new String(arg1));
    }

    public String getMinTLSVersion() {
        return this.minTLSVersion;
    }

    public A withMinTLSVersion(String minTLSVersion) {
        this.minTLSVersion=minTLSVersion; return (A) this;
    }

    public Boolean hasMinTLSVersion() {
        return this.minTLSVersion != null;
    }

    public A withNewMinTLSVersion(String arg1) {
        return (A)withMinTLSVersion(new String(arg1));
    }

    public A withNewMinTLSVersion(StringBuilder arg1) {
        return (A)withMinTLSVersion(new String(arg1));
    }

    public A withNewMinTLSVersion(StringBuffer arg1) {
        return (A)withMinTLSVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TLSProfileSpecFluentImpl that = (TLSProfileSpecFluentImpl) o;
        if (ciphers != null ? !ciphers.equals(that.ciphers) :that.ciphers != null) return false;
        if (minTLSVersion != null ? !minTLSVersion.equals(that.minTLSVersion) :that.minTLSVersion != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ciphers,  minTLSVersion,  super.hashCode());
    }

}
