package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ServiceCatalogAPIServerListFluent<A extends ServiceCatalogAPIServerListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ServiceCatalogAPIServer item);
    public A setToItems(int index,ServiceCatalogAPIServer item);
    public A addToItems(ServiceCatalogAPIServer... items);
    public A addAllToItems(Collection<ServiceCatalogAPIServer> items);
    public A removeFromItems(ServiceCatalogAPIServer... items);
    public A removeAllFromItems(Collection<ServiceCatalogAPIServer> items);
    public A removeMatchingFromItems(Predicate<ServiceCatalogAPIServerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ServiceCatalogAPIServer> getItems();
    public List<ServiceCatalogAPIServer> buildItems();
    public ServiceCatalogAPIServer buildItem(int index);
    public ServiceCatalogAPIServer buildFirstItem();
    public ServiceCatalogAPIServer buildLastItem();
    public ServiceCatalogAPIServer buildMatchingItem(Predicate<ServiceCatalogAPIServerBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ServiceCatalogAPIServerBuilder> predicate);
    public A withItems(List<ServiceCatalogAPIServer> items);
    public A withItems(ServiceCatalogAPIServer... items);
    public Boolean hasItems();
    public ServiceCatalogAPIServerListFluent.ItemsNested<A> addNewItem();
    public ServiceCatalogAPIServerListFluent.ItemsNested<A> addNewItemLike(ServiceCatalogAPIServer item);
    public ServiceCatalogAPIServerListFluent.ItemsNested<A> setNewItemLike(int index,ServiceCatalogAPIServer item);
    public ServiceCatalogAPIServerListFluent.ItemsNested<A> editItem(int index);
    public ServiceCatalogAPIServerListFluent.ItemsNested<A> editFirstItem();
    public ServiceCatalogAPIServerListFluent.ItemsNested<A> editLastItem();
    public ServiceCatalogAPIServerListFluent.ItemsNested<A> editMatchingItem(Predicate<ServiceCatalogAPIServerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogAPIServerFluent<ServiceCatalogAPIServerListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
