package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class StaticIPAMDNSFluentImpl<A extends StaticIPAMDNSFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StaticIPAMDNSFluent<A> {

    private String domain;
    private List<String> nameservers = new ArrayList<String>();
    private List<String> search = new ArrayList<String>();

    public StaticIPAMDNSFluentImpl() { 
    }


    public StaticIPAMDNSFluentImpl(StaticIPAMDNS instance) { 
        this.withDomain(instance.getDomain()); 
        this.withNameservers(instance.getNameservers()); 
        this.withSearch(instance.getSearch()); 
    }


    public String getDomain() {
        return this.domain;
    }

    public A withDomain(String domain) {
        this.domain=domain; return (A) this;
    }

    public Boolean hasDomain() {
        return this.domain != null;
    }

    public A withNewDomain(String arg1) {
        return (A)withDomain(new String(arg1));
    }

    public A withNewDomain(StringBuilder arg1) {
        return (A)withDomain(new String(arg1));
    }

    public A withNewDomain(StringBuffer arg1) {
        return (A)withDomain(new String(arg1));
    }

    public A addToNameservers(int index,String item) {
        if (this.nameservers == null) {this.nameservers = new ArrayList<String>();}
        this.nameservers.add(index, item);
        return (A)this;
    }

    public A setToNameservers(int index,String item) {
        if (this.nameservers == null) {this.nameservers = new ArrayList<String>();}
        this.nameservers.set(index, item); return (A)this;
    }

    public A addToNameservers(String... items) {
        if (this.nameservers == null) {this.nameservers = new ArrayList<String>();}
        for (String item : items) {this.nameservers.add(item);} return (A)this;
    }

    public A addAllToNameservers(Collection<String> items) {
        if (this.nameservers == null) {this.nameservers = new ArrayList<String>();}
        for (String item : items) {this.nameservers.add(item);} return (A)this;
    }

    public A removeFromNameservers(String... items) {
        for (String item : items) {if (this.nameservers!= null){ this.nameservers.remove(item);}} return (A)this;
    }

    public A removeAllFromNameservers(Collection<String> items) {
        for (String item : items) {if (this.nameservers!= null){ this.nameservers.remove(item);}} return (A)this;
    }

    public List<String> getNameservers() {
        return this.nameservers;
    }

    public String getNameserver(int index) {
        return this.nameservers.get(index);
    }

    public String getFirstNameserver() {
        return this.nameservers.get(0);
    }

    public String getLastNameserver() {
        return this.nameservers.get(nameservers.size() - 1);
    }

    public String getMatchingNameserver(Predicate<String> predicate) {
        for (String item: nameservers) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNameserver(Predicate<String> predicate) {
        for (String item: nameservers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNameservers(List<String> nameservers) {
        if (this.nameservers != null) { _visitables.get("nameservers").removeAll(this.nameservers);}
        if (nameservers != null) {this.nameservers = new ArrayList<String>(); for (String item : nameservers){this.addToNameservers(item);}} else { this.nameservers = null;} return (A) this;
    }

    public A withNameservers(String... nameservers) {
        if (this.nameservers != null) {this.nameservers.clear();}
        if (nameservers != null) {for (String item :nameservers){ this.addToNameservers(item);}} return (A) this;
    }

    public Boolean hasNameservers() {
        return nameservers != null && !nameservers.isEmpty();
    }

    public A addNewNameserver(String arg1) {
        return (A)addToNameservers(new String(arg1));
    }

    public A addNewNameserver(StringBuilder arg1) {
        return (A)addToNameservers(new String(arg1));
    }

    public A addNewNameserver(StringBuffer arg1) {
        return (A)addToNameservers(new String(arg1));
    }

    public A addToSearch(int index,String item) {
        if (this.search == null) {this.search = new ArrayList<String>();}
        this.search.add(index, item);
        return (A)this;
    }

    public A setToSearch(int index,String item) {
        if (this.search == null) {this.search = new ArrayList<String>();}
        this.search.set(index, item); return (A)this;
    }

    public A addToSearch(String... items) {
        if (this.search == null) {this.search = new ArrayList<String>();}
        for (String item : items) {this.search.add(item);} return (A)this;
    }

    public A addAllToSearch(Collection<String> items) {
        if (this.search == null) {this.search = new ArrayList<String>();}
        for (String item : items) {this.search.add(item);} return (A)this;
    }

    public A removeFromSearch(String... items) {
        for (String item : items) {if (this.search!= null){ this.search.remove(item);}} return (A)this;
    }

    public A removeAllFromSearch(Collection<String> items) {
        for (String item : items) {if (this.search!= null){ this.search.remove(item);}} return (A)this;
    }

    public List<String> getSearch() {
        return this.search;
    }

    public String getSearch(int index) {
        return this.search.get(index);
    }

    public String getFirstSearch() {
        return this.search.get(0);
    }

    public String getLastSearch() {
        return this.search.get(search.size() - 1);
    }

    public String getMatchingSearch(Predicate<String> predicate) {
        for (String item: search) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingSearch(Predicate<String> predicate) {
        for (String item: search) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSearch(List<String> search) {
        if (this.search != null) { _visitables.get("search").removeAll(this.search);}
        if (search != null) {this.search = new ArrayList<String>(); for (String item : search){this.addToSearch(item);}} else { this.search = null;} return (A) this;
    }

    public A withSearch(String... search) {
        if (this.search != null) {this.search.clear();}
        if (search != null) {for (String item :search){ this.addToSearch(item);}} return (A) this;
    }

    public Boolean hasSearch() {
        return search != null && !search.isEmpty();
    }

    public A addNewSearch(String arg1) {
        return (A)addToSearch(new String(arg1));
    }

    public A addNewSearch(StringBuilder arg1) {
        return (A)addToSearch(new String(arg1));
    }

    public A addNewSearch(StringBuffer arg1) {
        return (A)addToSearch(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StaticIPAMDNSFluentImpl that = (StaticIPAMDNSFluentImpl) o;
        if (domain != null ? !domain.equals(that.domain) :that.domain != null) return false;
        if (nameservers != null ? !nameservers.equals(that.nameservers) :that.nameservers != null) return false;
        if (search != null ? !search.equals(that.search) :that.search != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(domain,  nameservers,  search,  super.hashCode());
    }

}
