package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface StaticIPAMDNSFluent<A extends StaticIPAMDNSFluent<A>> extends Fluent<A> {


    public String getDomain();
    public A withDomain(String domain);
    public Boolean hasDomain();
    public A withNewDomain(String arg1);
    public A withNewDomain(StringBuilder arg1);
    public A withNewDomain(StringBuffer arg1);
    public A addToNameservers(int index,String item);
    public A setToNameservers(int index,String item);
    public A addToNameservers(String... items);
    public A addAllToNameservers(Collection<String> items);
    public A removeFromNameservers(String... items);
    public A removeAllFromNameservers(Collection<String> items);
    public List<String> getNameservers();
    public String getNameserver(int index);
    public String getFirstNameserver();
    public String getLastNameserver();
    public String getMatchingNameserver(Predicate<String> predicate);
    public Boolean hasMatchingNameserver(Predicate<String> predicate);
    public A withNameservers(List<String> nameservers);
    public A withNameservers(String... nameservers);
    public Boolean hasNameservers();
    public A addNewNameserver(String arg1);
    public A addNewNameserver(StringBuilder arg1);
    public A addNewNameserver(StringBuffer arg1);
    public A addToSearch(int index,String item);
    public A setToSearch(int index,String item);
    public A addToSearch(String... items);
    public A addAllToSearch(Collection<String> items);
    public A removeFromSearch(String... items);
    public A removeAllFromSearch(Collection<String> items);
    public List<String> getSearch();
    public String getSearch(int index);
    public String getFirstSearch();
    public String getLastSearch();
    public String getMatchingSearch(Predicate<String> predicate);
    public Boolean hasMatchingSearch(Predicate<String> predicate);
    public A withSearch(List<String> search);
    public A withSearch(String... search);
    public Boolean hasSearch();
    public A addNewSearch(String arg1);
    public A addNewSearch(StringBuilder arg1);
    public A addNewSearch(StringBuffer arg1);
}
