package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class StaticIPAMAddressesFluentImpl<A extends StaticIPAMAddressesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StaticIPAMAddressesFluent<A> {

    private String address;
    private String gateway;

    public StaticIPAMAddressesFluentImpl() { 
    }


    public StaticIPAMAddressesFluentImpl(StaticIPAMAddresses instance) { 
        this.withAddress(instance.getAddress()); 
        this.withGateway(instance.getGateway()); 
    }


    public String getAddress() {
        return this.address;
    }

    public A withAddress(String address) {
        this.address=address; return (A) this;
    }

    public Boolean hasAddress() {
        return this.address != null;
    }

    public A withNewAddress(String arg1) {
        return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuilder arg1) {
        return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuffer arg1) {
        return (A)withAddress(new String(arg1));
    }

    public String getGateway() {
        return this.gateway;
    }

    public A withGateway(String gateway) {
        this.gateway=gateway; return (A) this;
    }

    public Boolean hasGateway() {
        return this.gateway != null;
    }

    public A withNewGateway(String arg1) {
        return (A)withGateway(new String(arg1));
    }

    public A withNewGateway(StringBuilder arg1) {
        return (A)withGateway(new String(arg1));
    }

    public A withNewGateway(StringBuffer arg1) {
        return (A)withGateway(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StaticIPAMAddressesFluentImpl that = (StaticIPAMAddressesFluentImpl) o;
        if (address != null ? !address.equals(that.address) :that.address != null) return false;
        if (gateway != null ? !gateway.equals(that.gateway) :that.gateway != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(address,  gateway,  super.hashCode());
    }

}
