package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StaticIPAMAddressesBuilder extends StaticIPAMAddressesFluentImpl<StaticIPAMAddressesBuilder> implements VisitableBuilder<StaticIPAMAddresses,StaticIPAMAddressesBuilder> {

    StaticIPAMAddressesFluent<?> fluent;
    Boolean validationEnabled;

    public StaticIPAMAddressesBuilder() { 
        this(true);
    }


    public StaticIPAMAddressesBuilder(Boolean validationEnabled) { 
        this(new StaticIPAMAddresses(), validationEnabled);
    }


    public StaticIPAMAddressesBuilder(StaticIPAMAddressesFluent<?> fluent) { 
        this(fluent, true);
    }


    public StaticIPAMAddressesBuilder(StaticIPAMAddressesFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new StaticIPAMAddresses(), validationEnabled);
    }


    public StaticIPAMAddressesBuilder(StaticIPAMAddressesFluent<?> fluent,StaticIPAMAddresses instance) { 
        this(fluent, instance, true);
    }


    public StaticIPAMAddressesBuilder(StaticIPAMAddressesFluent<?> fluent,StaticIPAMAddresses instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAddress(instance.getAddress()); 
        fluent.withGateway(instance.getGateway()); 
        this.validationEnabled = validationEnabled; 
    }


    public StaticIPAMAddressesBuilder(StaticIPAMAddresses instance) { 
        this(instance,true);
    }


    public StaticIPAMAddressesBuilder(StaticIPAMAddresses instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAddress(instance.getAddress()); 
        this.withGateway(instance.getGateway()); 
        this.validationEnabled = validationEnabled; 
    }


    public StaticIPAMAddresses build() {
        StaticIPAMAddresses buildable = new StaticIPAMAddresses(fluent.getAddress(),fluent.getGateway());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StaticIPAMAddressesBuilder that = (StaticIPAMAddressesBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
